package com.ruoyi.system.controller.activity;

import java.util.List;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

import lombok.RequiredArgsConstructor;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.*;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.validation.annotation.Validated;
import com.ruoyi.common.annotation.RepeatSubmit;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import com.ruoyi.common.core.validate.QueryGroup;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.system.domain.vo.ZkActivityContentVo;
import com.ruoyi.system.domain.bo.ZkActivityContentBo;
import com.ruoyi.system.service.IZkActivityContentService;
import com.ruoyi.common.core.page.TableDataInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 活动内容Controller
 *
 * @author ruoyi
 * @date 2021-10-27
 */
@Validated
//@Api(value = "活动内容控制器", tags = {"活动内容管理"})
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@RestController
@RequestMapping("/system/activityContent")
public class ZkActivityContentController extends BaseController {

    private final IZkActivityContentService iZkActivityContentService;

    /**
     * 查询活动内容列表
     */
//    @ApiOperation("查询活动内容列表")
    @PreAuthorize("@ss.hasPermi('system:activityContent:list')")
    @GetMapping("/list")
    public TableDataInfo<ZkActivityContentVo> list(@Validated(QueryGroup.class) ZkActivityContentBo bo) {
        return iZkActivityContentService.queryPageList(bo);
    }

    /**
     * 导出活动内容列表
     */
//    @ApiOperation("导出活动内容列表")
    @PreAuthorize("@ss.hasPermi('system:activityContent:export')")
    @Log(title = "活动内容", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public void export(@Validated ZkActivityContentBo bo, HttpServletResponse response) {
        List<ZkActivityContentVo> list = iZkActivityContentService.queryList(bo);
        ExcelUtil.exportExcel(list, "活动内容", ZkActivityContentVo.class, response);
    }

    /**
     * 获取活动内容详细信息
     */
//    @ApiOperation("获取活动内容详细信息")
    @PreAuthorize("@ss.hasPermi('system:activityContent:query')")
    @GetMapping("/{id}")
    public AjaxResult<ZkActivityContentVo> getInfo(@NotNull(message = "主键不能为空")
                                                  @PathVariable("id") Long id) {
        return AjaxResult.success(iZkActivityContentService.queryById(id));
    }

    /**
     * 新增活动内容
     */
//    @ApiOperation("新增活动内容")
    @PreAuthorize("@ss.hasPermi('system:activityContent:add')")
    @Log(title = "活动内容", businessType = BusinessType.INSERT)
    @RepeatSubmit()
    @PostMapping()
    public AjaxResult<Void> add(@Validated(AddGroup.class) @RequestBody ZkActivityContentBo bo) {
        return toAjax(iZkActivityContentService.insertByBo(bo) ? 1 : 0);
    }

    /**
     * 修改活动内容
     */
//    @ApiOperation("修改活动内容")
    @PreAuthorize("@ss.hasPermi('system:activityContent:edit')")
    @Log(title = "活动内容", businessType = BusinessType.UPDATE)
    @RepeatSubmit()
    @PutMapping()
    public AjaxResult<Void> edit(@Validated(EditGroup.class) @RequestBody ZkActivityContentBo bo) {
        return toAjax(iZkActivityContentService.updateByBo(bo) ? 1 : 0);
    }

    /**
     * 删除活动内容
     */
//    @ApiOperation("删除活动内容")
    @PreAuthorize("@ss.hasPermi('system:activityContent:remove')")
    @Log(title = "活动内容" , businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult<Void> remove(@NotEmpty(message = "主键不能为空")
                                       @PathVariable Long[] ids) {
        return toAjax(iZkActivityContentService.deleteWithValidByIds(Arrays.asList(ids), true) ? 1 : 0);
    }
}
