package com.ruoyi.system.controller.activity;

import java.util.List;
import java.util.Arrays;

import com.github.pagehelper.PageInfo;
import com.ruoyi.system.domain.ZkActivityInfo;
import com.ruoyi.system.domain.bo.ZkActivityInfoBo;
import com.ruoyi.system.domain.bo.ZkActivityInfoBo2;
import lombok.RequiredArgsConstructor;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.*;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.validation.annotation.Validated;
import com.ruoyi.common.annotation.RepeatSubmit;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import com.ruoyi.common.core.validate.QueryGroup;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.system.domain.vo.ZkActivityInfoVo;
import com.ruoyi.system.service.IZkActivityInfoService;
import com.ruoyi.common.core.page.TableDataInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 活动详情主体Controller
 *
 * @author ruoyi
 * @date 2021-10-27
 */
@Validated
@Api(value = "活动详情主体控制器", tags = {"活动详情主体管理"})
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@RestController
@RequestMapping("/system/activityInfo")
public class ZkActivityInfoController extends BaseController {

    private final IZkActivityInfoService iZkActivityInfoService;

    /**
     * 查询活动详情主体列表
     */
//    @ApiOperation("查询活动详情主体列表")
    @PreAuthorize("@ss.hasPermi('system:activityInfo:list')")
    @GetMapping("/list")
    public TableDataInfo<ZkActivityInfoVo> list(@Validated(QueryGroup.class) ZkActivityInfoBo bo) {
        return iZkActivityInfoService.queryPageList(bo);
    }

    /**
     * 导出活动详情主体列表
     */
//    @ApiOperation("导出活动详情主体列表")
    @PreAuthorize("@ss.hasPermi('system:activityInfo:export')")
    @Log(title = "活动详情主体", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public void export(@Validated ZkActivityInfoBo bo, HttpServletResponse response) {
        List<ZkActivityInfoVo> list = iZkActivityInfoService.queryList(bo);
        ExcelUtil.exportExcel(list, "活动详情主体", ZkActivityInfoVo.class, response);
    }

    /**
     * 获取活动详情主体详细信息
     */
//    @ApiOperation("获取活动详情主体详细信息")
    @PreAuthorize("@ss.hasPermi('system:activityInfo:query')")
    @GetMapping("/{id}")
    public AjaxResult<ZkActivityInfoVo> getInfo(@NotNull(message = "主键不能为空")
                                                  @PathVariable("id") Long id) {
        return AjaxResult.success(iZkActivityInfoService.queryById(id));
    }

    /**
     * 新增活动详情主体
     */
//    @ApiOperation("新增活动详情主体")
    @PreAuthorize("@ss.hasPermi('system:activityInfo:add')")
    @Log(title = "活动详情主体", businessType = BusinessType.INSERT)
    @RepeatSubmit()
    @PostMapping()
    public AjaxResult<Void> add(@Validated(AddGroup.class) @RequestBody ZkActivityInfoBo bo) {
        return toAjax(iZkActivityInfoService.insertByBo(bo) ? 1 : 0);
    }

    /**
     * 修改活动详情主体
     */
//    @ApiOperation("修改活动详情主体")
    @PreAuthorize("@ss.hasPermi('system:activityInfo:edit')")
    @Log(title = "活动详情主体", businessType = BusinessType.UPDATE)
    @RepeatSubmit()
    @PutMapping()
    public AjaxResult<Void> edit(@Validated(EditGroup.class) @RequestBody ZkActivityInfoBo bo) {
        return toAjax(iZkActivityInfoService.updateByBo(bo) ? 1 : 0);
    }

    /**
     * 删除活动详情主体
     */
//    @ApiOperation("删除活动详情主体")
    @PreAuthorize("@ss.hasPermi('system:activityInfo:remove')")
    @Log(title = "活动详情主体" , businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult<Void> remove(@NotEmpty(message = "主键不能为空")
                                       @PathVariable Long[] ids) {
        return toAjax(iZkActivityInfoService.deleteWithValidByIds(Arrays.asList(ids), true) ? 1 : 0);
    }

    /**
     * 综合查询
     */
    @ApiOperation("综合查询")
    //@PreAuthorize("@ss.hasPermi('system:activityInfo:query')")
    @GetMapping("/zhcx")
    public AjaxResult<PageInfo> zhcx(@Validated(QueryGroup.class) ZkActivityInfoBo2 bo) {
        return AjaxResult.success(iZkActivityInfoService.queryByZHCX(bo));
    }
}
