package com.ruoyi.system.controller.activity;

import java.util.List;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

import lombok.RequiredArgsConstructor;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.*;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.validation.annotation.Validated;
import com.ruoyi.common.annotation.RepeatSubmit;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import com.ruoyi.common.core.validate.QueryGroup;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.system.domain.vo.ZkActivityTypeContentVo;
import com.ruoyi.system.domain.bo.ZkActivityTypeContentBo;
import com.ruoyi.system.service.IZkActivityTypeContentService;
import com.ruoyi.common.core.page.TableDataInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 活动类型与活动内容关联Controller
 *
 * @author ruoyi
 * @date 2021-10-27
 */
@Validated
//@Api(value = "活动类型与活动内容关联控制器", tags = {"活动类型与活动内容关联管理"})
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@RestController
@RequestMapping("/system/activityTypeContent")
public class ZkActivityTypeContentController extends BaseController {

    private final IZkActivityTypeContentService iZkActivityTypeContentService;

    /**
     * 查询活动类型与活动内容关联列表
     */
//    @ApiOperation("查询活动类型与活动内容关联列表")
    @PreAuthorize("@ss.hasPermi('system:activityTypeContent:list')")
    @GetMapping("/list")
    public TableDataInfo<ZkActivityTypeContentVo> list(@Validated(QueryGroup.class) ZkActivityTypeContentBo bo) {
        return iZkActivityTypeContentService.queryPageList(bo);
    }

    /**
     * 导出活动类型与活动内容关联列表
     */
//    @ApiOperation("导出活动类型与活动内容关联列表")
    @PreAuthorize("@ss.hasPermi('system:activityTypeContent:export')")
    @Log(title = "活动类型与活动内容关联", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public void export(@Validated ZkActivityTypeContentBo bo, HttpServletResponse response) {
        List<ZkActivityTypeContentVo> list = iZkActivityTypeContentService.queryList(bo);
        ExcelUtil.exportExcel(list, "活动类型与活动内容关联", ZkActivityTypeContentVo.class, response);
    }

    /**
     * 获取活动类型与活动内容关联详细信息
     */
//    @ApiOperation("获取活动类型与活动内容关联详细信息")
    @PreAuthorize("@ss.hasPermi('system:activityTypeContent:query')")
    @GetMapping("/{id}")
    public AjaxResult<ZkActivityTypeContentVo> getInfo(@NotNull(message = "主键不能为空")
                                                  @PathVariable("id") Long id) {
        return AjaxResult.success(iZkActivityTypeContentService.queryById(id));
    }

    /**
     * 新增活动类型与活动内容关联
     */
//    @ApiOperation("新增活动类型与活动内容关联")
    @PreAuthorize("@ss.hasPermi('system:activityTypeContent:add')")
    @Log(title = "活动类型与活动内容关联", businessType = BusinessType.INSERT)
    @RepeatSubmit()
    @PostMapping()
    public AjaxResult<Void> add(@Validated(AddGroup.class) @RequestBody ZkActivityTypeContentBo bo) {
        return toAjax(iZkActivityTypeContentService.insertByBo(bo) ? 1 : 0);
    }

    /**
     * 修改活动类型与活动内容关联
     */
//    @ApiOperation("修改活动类型与活动内容关联")
    @PreAuthorize("@ss.hasPermi('system:activityTypeContent:edit')")
    @Log(title = "活动类型与活动内容关联", businessType = BusinessType.UPDATE)
    @RepeatSubmit()
    @PutMapping()
    public AjaxResult<Void> edit(@Validated(EditGroup.class) @RequestBody ZkActivityTypeContentBo bo) {
        return toAjax(iZkActivityTypeContentService.updateByBo(bo) ? 1 : 0);
    }

    /**
     * 删除活动类型与活动内容关联
     */
//    @ApiOperation("删除活动类型与活动内容关联")
    @PreAuthorize("@ss.hasPermi('system:activityTypeContent:remove')")
    @Log(title = "活动类型与活动内容关联" , businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult<Void> remove(@NotEmpty(message = "主键不能为空")
                                       @PathVariable Long[] ids) {
        return toAjax(iZkActivityTypeContentService.deleteWithValidByIds(Arrays.asList(ids), true) ? 1 : 0);
    }
}
