package com.ruoyi.system.controller.activity;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.annotation.RepeatSubmit;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import com.ruoyi.common.core.validate.QueryGroup;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.system.domain.bo.ZkTitleTypeBo;
import com.ruoyi.system.domain.vo.ZkTitleTypeVo;
import com.ruoyi.system.service.IZkTitleTypeService;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.List;

/**
 * 活动分类(组织活动/民主评议/专项活动)Controller
 *
 * @author ruoyi
 * @date 2021-10-27
 */
@Validated
//@Api(value = "活动分类(组织活动/民主评议/专项活动)控制器", tags = {"活动分类(组织活动/民主评议/专项活动)管理"})
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@RestController
@RequestMapping("/system/titleType")
public class ZkTitleTypeController extends BaseController {

    private final IZkTitleTypeService iZkTitleTypeService;

    /**
     * 查询活动分类(组织活动/民主评议/专项活动)列表
     */
//    @ApiOperation("查询活动分类(组织活动/民主评议/专项活动)列表")
    @PreAuthorize("@ss.hasPermi('system:titleType:list')")
    @GetMapping("/list")
    public TableDataInfo<ZkTitleTypeVo> list(@Validated(QueryGroup.class) ZkTitleTypeBo bo) {
        return iZkTitleTypeService.queryPageList(bo);
    }

    /**
     * 导出活动分类(组织活动/民主评议/专项活动)列表
     */
//    @ApiOperation("导出活动分类(组织活动/民主评议/专项活动)列表")
    @PreAuthorize("@ss.hasPermi('system:titleType:export')")
    @Log(title = "活动分类(组织活动/民主评议/专项活动)", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public void export(@Validated ZkTitleTypeBo bo, HttpServletResponse response) {
        List<ZkTitleTypeVo> list = iZkTitleTypeService.queryList(bo);
        ExcelUtil.exportExcel(list, "活动分类(组织活动/民主评议/专项活动)", ZkTitleTypeVo.class, response);
    }

    /**
     * 获取活动分类(组织活动/民主评议/专项活动)详细信息
     */
//    @ApiOperation("获取活动分类(组织活动/民主评议/专项活动)详细信息")
    @PreAuthorize("@ss.hasPermi('system:titleType:query')")
    @GetMapping("/{id}")
    public AjaxResult<ZkTitleTypeVo> getInfo(@NotNull(message = "主键不能为空")
                                             @PathVariable("id") Long id) {
        return AjaxResult.success(iZkTitleTypeService.queryById(id));
    }

    /**
     * 新增活动分类(组织活动/民主评议/专项活动)
     */
//    @ApiOperation("新增活动分类(组织活动/民主评议/专项活动)")
    @PreAuthorize("@ss.hasPermi('system:titleType:add')")
    @Log(title = "活动分类(组织活动/民主评议/专项活动)", businessType = BusinessType.INSERT)
    @RepeatSubmit()
    @PostMapping()
    public AjaxResult<Void> add(@Validated(AddGroup.class) @RequestBody ZkTitleTypeBo bo) {
        return toAjax(iZkTitleTypeService.insertByBo(bo) ? 1 : 0);
    }

    /**
     * 修改活动分类(组织活动/民主评议/专项活动)
     */
//    @ApiOperation("修改活动分类(组织活动/民主评议/专项活动)")
    @PreAuthorize("@ss.hasPermi('system:titleType:edit')")
    @Log(title = "活动分类(组织活动/民主评议/专项活动)", businessType = BusinessType.UPDATE)
    @RepeatSubmit()
    @PutMapping()
    public AjaxResult<Void> edit(@Validated(EditGroup.class) @RequestBody ZkTitleTypeBo bo) {
        return toAjax(iZkTitleTypeService.updateByBo(bo) ? 1 : 0);
    }

    /**
     * 删除活动分类(组织活动/民主评议/专项活动)
     */
//    @ApiOperation("删除活动分类(组织活动/民主评议/专项活动)")
    @PreAuthorize("@ss.hasPermi('system:titleType:remove')")
    @Log(title = "活动分类(组织活动/民主评议/专项活动)", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult<Void> remove(@NotEmpty(message = "主键不能为空")
                                   @PathVariable Long[] ids) {
        return toAjax(iZkTitleTypeService.deleteWithValidByIds(Arrays.asList(ids), true) ? 1 : 0);
    }

}
