package com.ruoyi.system.controller.api;

import cn.hutool.core.lang.Assert;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysDept;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.system.service.IBaseDataActivityService;
import com.ruoyi.system.service.ISysDeptService;
import com.ruoyi.system.service.ISysUserService;
import io.swagger.annotations.*;
import lombok.RequiredArgsConstructor;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Validated
@Api(value = "活动基础数据", tags = {"活动基础数据"})
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@RestController
@RequestMapping("/api/base")
public class ActivityBaseDataController {

    private final IBaseDataActivityService baseDataActivityService;

    private final ISysDeptService deptService;

    private final ISysUserService sysUserService;

    @ApiOperation("获取活动内容")
    @GetMapping("/getActivityContent")
    @ApiParam(name = "key", value = "活动类型key")
    public AjaxResult<List<Map<String, Object>>> getActivityContent(String key) {
        if (Strings.isNotEmpty(key)) {
            return AjaxResult.success(baseDataActivityService.getActivityContentDict(key));
        } else {
            return AjaxResult.success(baseDataActivityService.getActivityContentDict());
        }
    }

    @ApiOperation("获取部门树")
    @GetMapping("/getDeptTree")
    public AjaxResult getDeptTree() {
        Long deptId = SecurityUtils.getDeptId();
        List<SysDept> list = deptService.selectDeptTreeById(deptId, false);
        return AjaxResult.success(deptService.buildDeptTreeSelect(list));
    }

    @ApiOperation("获取部门树(下拉选项)")
    @GetMapping("/getDeptById")
    public AjaxResult getDeptById(Long deptId, String deptName) {
        List<SysDept> list = deptService.selectDeptTreeById(deptId, deptName);
        List<Map<String, Object>> mapList = new ArrayList<>();
        Map<String, Object> map;
        for (SysDept dept : list) {
            map = new HashMap<>();
            map.put("value", dept.getDeptId());
            map.put("label", dept.getDeptName());
            map.put("role", dept.getRoleFlag());
            mapList.add(map);
        }
        return AjaxResult.success(mapList);
    }

    @ApiOperation("获取活动对象列表")
    @GetMapping("/getActivityObj")
    public AjaxResult getActivityObj(String typeValue) {
        /*if (Strings.isEmpty(typeValue)) {
            return AjaxResult.success();
        }*/
        return AjaxResult.success(baseDataActivityService.getPostList(typeValue));
    }

    @ApiOperation("获取活动对象人员")
    @GetMapping("/getActivityObjUser")
    @ApiImplicitParams({
        @ApiImplicitParam(name = "deptId", value = "部门id"),
        @ApiImplicitParam(name = "postId", value = "活动对象id（岗位id）"),
        @ApiImplicitParam(name = "typeValue", value = "活动类型Value")
    })
    public AjaxResult getObjUser(@RequestParam Long deptId, @RequestParam Long postId, @RequestParam String typeValue) {
        Assert.notNull(postId, "活动对象id不能为空");
        return AjaxResult.success(sysUserService.getUserByDeptId(deptId, postId, typeValue));
    }

    @ApiOperation("获取活动类型")
    @GetMapping("/getActivityType")
    public AjaxResult getActivityType(String roleFlag) {
        return AjaxResult.success(baseDataActivityService.getTypeList(roleFlag));
    }

    @ApiOperation("根据部门获取主持人")
    @GetMapping("/getHostUserByDeptId/{deptId}")
    public AjaxResult getHostUserByDeptId(@PathVariable Long deptId) {
        return AjaxResult.success(baseDataActivityService.getHostUserByDeptId(deptId));
    }

    @ApiOperation("查询不合格数据字典")
    @GetMapping("/getUnqualified")
    public AjaxResult getUnqualified() {
        return AjaxResult.success(baseDataActivityService.getUnqualified());
    }

    @ApiOperation("根据部门查询用户")
    @GetMapping("/getUserByDeptId")
    public AjaxResult getUserByDeptId(Long deptId){
        return AjaxResult.success(baseDataActivityService.getUserByDeptId(deptId));
    }
}
