package com.ruoyi.system.controller.api;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysDept;
import com.ruoyi.system.domain.bo.CockpitBo;
import com.ruoyi.system.service.ICockpitService;
import com.ruoyi.system.service.ISysDeptService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/cockpit")
@Api(value = "驾驶舱数据统计", tags = {"驾驶舱数据统计"})
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class CockpitController {

    private final ICockpitService cockpitService;

    private final ISysDeptService sysDeptService;


    @ApiOperation("获取部门树")
    @GetMapping("/getDeptTree")
    public AjaxResult getDeptTree() {
        List<SysDept> list = sysDeptService.selectDeptTreeById(100L, false);
        return AjaxResult.success(cockpitService.buildDeptTree(list));
    }

    @ApiOperation("党支部人员信息统计")
    @GetMapping("/getDzbDataCount")
    public AjaxResult getDept(CockpitBo bo) {
        return AjaxResult.success(cockpitService.getDept(bo));
    }

    @ApiOperation("三会一课——开展频次")
    @GetMapping("/getDevelopmentFrequency")
    public AjaxResult getDevelopmentFrequency(CockpitBo bo) {
        return AjaxResult.success(cockpitService.getDevelopmentFrequency(bo));
    }

    @ApiOperation("三会一课——活动内容")
    @GetMapping("/getActivityContent")
    public AjaxResult getActivityContent(CockpitBo bo) {
        return AjaxResult.success(cockpitService.getActivityContent(bo));
    }

    @ApiOperation("三会一课——到会率")
    @GetMapping("/getAttendanceRate")
    public AjaxResult getAttendanceRate(CockpitBo bo) {
        return AjaxResult.success(cockpitService.getAttendanceRate(bo));
    }

    @ApiOperation("三会一课——请假率")
    @GetMapping("/getLeaveRate")
    public AjaxResult getLeaveRate(CockpitBo bo) {
        return AjaxResult.success(cockpitService.getLeaveRate(bo));
    }

    @ApiOperation("主题党日")
    @GetMapping("/getThemePartyDay")
    public AjaxResult getThemePartyDay(CockpitBo bo) {
        return AjaxResult.success(cockpitService.getThemePartyDay(bo));
    }

    @ApiOperation("组织生活会")
    @GetMapping("/getPartyLife")
    public AjaxResult getPartyLife(CockpitBo bo) {
        return AjaxResult.success(cockpitService.getPartyLife(bo));
    }

    @ApiOperation("民主评议")
    @GetMapping("/getDemocraticAppraisal")
    public AjaxResult getDemocraticAppraisal(CockpitBo bo) {
        return AjaxResult.success(cockpitService.getDemocraticAppraisal(bo));
    }

    @ApiOperation("组织生活规范指数")
    @GetMapping("/getIndex")
    public AjaxResult getIndex(CockpitBo bo) {
        return AjaxResult.success(cockpitService.getIndex(bo));
    }

}
