package com.ruoyi.system.controller.api;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.system.domain.bo.ActivityInfoBo;
import com.ruoyi.system.domain.bo.ActivitySyncBo;
import com.ruoyi.system.domain.bo.OrganizationalActivityBo;
import com.ruoyi.system.domain.bo.OrganizationalActivityListBo;
import com.ruoyi.system.domain.vo.OrganizationalActivityInfoVo;
import com.ruoyi.system.service.IActivityService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Validated
@Api(value = "组织活动页面接口", tags = {"组织活动页面接口"})
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@RestController
@RequestMapping("/api/activity/organizational")
public class OrganizationalActivityController {

    //OrganizationalActivities
    private final IActivityService activityService;

    @ApiOperation(value = "组织活动列表")
    @GetMapping("/list")
    public TableDataInfo<OrganizationalActivityInfoVo> list(ActivityInfoBo bo) {
        bo.setTitleType(1);
        if (Strings.isEmpty(bo.getDeptId())) {
            bo.setDeptId(String.valueOf(SecurityUtils.getDeptId()));
        }
        return activityService.queryOrganizationalActivityPageList(bo);
    }

    @ApiOperation(value = "组织活动详情")
    @GetMapping("/getInfo/{id}")
    public AjaxResult getInfo(@PathVariable Long id) {
        return AjaxResult.success(activityService.getInfo(id));
    }

    @ApiOperation(value = "组织活动增加")
    @PostMapping("/add")
    public AjaxResult add(@Validated @RequestBody OrganizationalActivityBo bo) {
        bo.setTitleType(1L);
        return AjaxResult.success(activityService.add(bo));
    }

    @ApiOperation(value = "组织活动修改")
    @PostMapping("/edit")
    public AjaxResult edit(@Validated @RequestBody OrganizationalActivityBo bo) {
        bo.setTitleType(1L);
        return AjaxResult.success(activityService.edit(bo, 0));
    }

    @ApiOperation(value = "组织活动删除")
    @DeleteMapping("/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(activityService.delete(ids));
    }

    @ApiOperation(value = "同步组织活动")
    @PostMapping("/syncActivity")
    public AjaxResult syncActivity(@RequestBody ActivitySyncBo bo) {
        return AjaxResult.success(activityService.syncActivity(bo));
    }

    @ApiOperation(value = "同步组织活动新")
    @PostMapping("/syncActivityNew")
    public AjaxResult syncActivityNew(@Validated @RequestBody OrganizationalActivityListBo vo) {
        if (vo.getList() != null && vo.getList().size() > 0) {
            for (OrganizationalActivityBo activityBo : vo.getList()) {
                activityBo.setTitleType(1L);
                activityService.add(activityBo);
            }
        }
        return AjaxResult.success();
    }

    @ApiOperation("根据活动id查看评议结果")
    @GetMapping("/queryEvaluateById/{id}")
    public AjaxResult queryEvaluateById(@PathVariable Long id) {
        return AjaxResult.success(activityService.queryEvaluateById(id));
    }

}
