package com.ruoyi.system.controller.api;

import cn.hutool.core.lang.Assert;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.system.domain.ZkActivityContent;
import com.ruoyi.system.domain.ZkActivityInfoContent;
import com.ruoyi.system.domain.bo.ActivityInfoBo;
import com.ruoyi.system.domain.bo.OrganizationalActivityBo;
import com.ruoyi.system.domain.bo.SpecialActivityAddBo;
import com.ruoyi.system.domain.bo.SpecialActivityCorrectionBo;
import com.ruoyi.system.domain.vo.SpecialActivityInfoVo;
import com.ruoyi.system.service.IActivityService;
import com.ruoyi.system.service.IZkActivityContentService;
import com.ruoyi.system.service.IZkActivityInfoContentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Validated
@Api(value = "专项活动页面接口", tags = {"专项活动页面接口"})
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@RestController
@RequestMapping("/api/activity/special")
public class SpecialActivityController {

    //OrganizationalActivities
    private final IActivityService activityService;

    private final IZkActivityContentService contentService;

    @ApiOperation(value = "专项活动列表")
    @GetMapping("/list")
    public TableDataInfo<SpecialActivityInfoVo> list(ActivityInfoBo bo) {
        bo.setTitleType(4);
        if (Strings.isEmpty(bo.getDeptId())) {
            bo.setDeptId(String.valueOf(SecurityUtils.getDeptId()));
        }
        return activityService.querySpecialActivityPageList(bo);
    }

    @ApiOperation(value = "专项活动详情")
    @GetMapping("/getInfo/{id}")
    public AjaxResult getInfo(@PathVariable Long id) {
        return AjaxResult.success(activityService.getInfo(id));
    }

    @ApiOperation(value = "专项活动增加")
    @PostMapping("/add")
    public AjaxResult add(@Validated @RequestBody SpecialActivityAddBo bo) {
        Assert.notNull(SecurityUtils.getUserId(), "请先登录！");
        boolean flag = activityService.add(bo);
        if (flag) {
            return AjaxResult.success();
        } else {
            return AjaxResult.error();
        }
    }

    @ApiOperation(value = "专题活动执行")
    @PostMapping("/implement")
    public AjaxResult implement(@Validated @RequestBody OrganizationalActivityBo vo) {
        vo.setStatus(1);
        return AjaxResult.success(activityService.edit(vo, 1));
    }

    @ApiOperation(value = "专题活动修改")
    @PostMapping("/edit")
    public AjaxResult edit(@Validated @RequestBody OrganizationalActivityBo vo) {
        return AjaxResult.success(activityService.edit(vo, 0));
    }

    @ApiOperation(value = "专项活动删除")
    @DeleteMapping("/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(activityService.delete(ids));
    }

    @ApiOperation(value = "专项活动纠错")
    @PostMapping("/correction")
    public AjaxResult correction(@RequestBody SpecialActivityCorrectionBo bo) {
        LambdaQueryWrapper<ZkActivityContent> lqWrapper = new LambdaQueryWrapper();
        lqWrapper.eq(ZkActivityContent::getContentKey, bo.getContentKey());
        ZkActivityContent content = contentService.getOne(lqWrapper);
        ZkActivityInfoContent infoContent = new ZkActivityInfoContent();
        if (content != null) {
            infoContent.setContent(bo.getContent());
            infoContent.setContentKey(content.getContentKey());
            infoContent.setContentName(content.getContentName());
        }
        return AjaxResult.success(activityService.specialActivityCorrection(bo, content, infoContent));
    }

}
