package com.ruoyi.system.controller.statistics;

import java.util.List;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import lombok.RequiredArgsConstructor;

import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.*;

import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.validation.annotation.Validated;
import com.ruoyi.common.annotation.RepeatSubmit;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import com.ruoyi.common.core.validate.QueryGroup;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.system.domain.vo.TbDzbCountVo;
import com.ruoyi.system.domain.bo.TbDzbCountBo;
import com.ruoyi.system.service.ITbDzbCountService;
import com.ruoyi.common.core.page.TableDataInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 党支部基层数据大屏统计Controller
 *
 * @author ruoyi
 * @date 2021-10-26
 */
@Validated
//@Api(value = " 党支部基层数据大屏统计控制器", tags = {" 党支部基层数据大屏统计管理"})
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@RestController
@RequestMapping("/system/dzbCount")
public class TbDzbCountController extends BaseController {

    private final ITbDzbCountService iTbDzbCountService;

    @GetMapping("/getScreen")
//    @ApiOperation("查询基层大屏数据")
    public AjaxResult<List<Map<String, Object>>> getScreen() {
        return AjaxResult.success(iTbDzbCountService.getScreen());
    }


    /**
     * 查询 党支部基层数据大屏统计列表
     */
//    @ApiOperation("查询 党支部基层数据大屏统计列表")
    @PreAuthorize("@ss.hasPermi('system:dzbCount:list')")
    @GetMapping("/list")
    public TableDataInfo<TbDzbCountVo> list(@Validated(QueryGroup.class) TbDzbCountBo bo) {
        return iTbDzbCountService.queryPageList(bo);
    }

    /**
     * 导出 党支部基层数据大屏统计列表
     */
//    @ApiOperation("导出 党支部基层数据大屏统计列表")
    @PreAuthorize("@ss.hasPermi('system:dzbCount:export')")
    @Log(title = " 党支部基层数据大屏统计", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public void export(@Validated TbDzbCountBo bo, HttpServletResponse response) {
        List<TbDzbCountVo> list = iTbDzbCountService.queryList(bo);
        ExcelUtil.exportExcel(list, " 党支部基层数据大屏统计", TbDzbCountVo.class, response);
    }

    /**
     * 获取 党支部基层数据大屏统计详细信息
     */
//    @ApiOperation("获取 党支部基层数据大屏统计详细信息")
    @PreAuthorize("@ss.hasPermi('system:dzbCount:query')")
    @GetMapping("/{id}")
    public AjaxResult<TbDzbCountVo> getInfo(@NotNull(message = "主键不能为空")
                                            @PathVariable("id") Long id) {
        return AjaxResult.success(iTbDzbCountService.queryById(id));
    }

    /**
     * 新增 党支部基层数据大屏统计
     */
//    @ApiOperation("新增 党支部基层数据大屏统计")
    @PreAuthorize("@ss.hasPermi('system:dzbCount:add')")
    @Log(title = " 党支部基层数据大屏统计", businessType = BusinessType.INSERT)
    @RepeatSubmit()
    @PostMapping()
    public AjaxResult<Void> add(@Validated(AddGroup.class) @RequestBody TbDzbCountBo bo) {
        return toAjax(iTbDzbCountService.insertByBo(bo) ? 1 : 0);
    }

    /**
     * 修改 党支部基层数据大屏统计
     */
//    @ApiOperation("修改 党支部基层数据大屏统计")
    @PreAuthorize("@ss.hasPermi('system:dzbCount:edit')")
    @Log(title = " 党支部基层数据大屏统计", businessType = BusinessType.UPDATE)
    @RepeatSubmit()
    @PutMapping()
    public AjaxResult<Void> edit(@Validated(EditGroup.class) @RequestBody TbDzbCountBo bo) {
        return toAjax(iTbDzbCountService.updateByBo(bo) ? 1 : 0);
    }

}
