package com.ruoyi.system.controller.statistics;

import java.util.List;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import lombok.RequiredArgsConstructor;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.*;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.validation.annotation.Validated;
import com.ruoyi.common.annotation.RepeatSubmit;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import com.ruoyi.common.core.validate.QueryGroup;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.system.domain.vo.TbDzbGatheringsCountVo;
import com.ruoyi.system.domain.bo.TbDzbGatheringsCountBo;
import com.ruoyi.system.service.ITbDzbGatheringsCountService;
import com.ruoyi.common.core.page.TableDataInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 组织生活会/民主生活会 数据统计Controller
 *
 * @author ruoyi
 * @date 2021-10-26
 */
@Validated
//@Api(value = "组织生活会/民主生活会 数据统计控制器", tags = {"组织生活会/民主生活会 数据统计管理"})
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@RestController
@RequestMapping("/system/dzbGatheringsCount")
public class TbDzbGatheringsCountController extends BaseController {

    private final ITbDzbGatheringsCountService iTbDzbGatheringsCountService;

//    @ApiOperation("查询组织生活会/民主生活会数据统计大屏")
    @GetMapping("/getScreen")
    public AjaxResult<List<Map<String, Object>>> getScreen(){
        return AjaxResult.success(iTbDzbGatheringsCountService.getScreen());
    }

    /**
     * 查询组织生活会/民主生活会 数据统计列表
     */
//    @ApiOperation("查询组织生活会/民主生活会 数据统计列表")
    @PreAuthorize("@ss.hasPermi('system:dzbGatheringsCount:list')")
    @GetMapping("/list")
    public TableDataInfo<TbDzbGatheringsCountVo> list(@Validated(QueryGroup.class) TbDzbGatheringsCountBo bo) {
        return iTbDzbGatheringsCountService.queryPageList(bo);
    }

    /**
     * 导出组织生活会/民主生活会 数据统计列表
     */
//    @ApiOperation("导出组织生活会/民主生活会 数据统计列表")
    @PreAuthorize("@ss.hasPermi('system:dzbGatheringsCount:export')")
    @Log(title = "组织生活会/民主生活会 数据统计", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public void export(@Validated TbDzbGatheringsCountBo bo, HttpServletResponse response) {
        List<TbDzbGatheringsCountVo> list = iTbDzbGatheringsCountService.queryList(bo);
        ExcelUtil.exportExcel(list, "组织生活会/民主生活会 数据统计", TbDzbGatheringsCountVo.class, response);
    }

    /**
     * 获取组织生活会/民主生活会 数据统计详细信息
     */
//    @ApiOperation("获取组织生活会/民主生活会 数据统计详细信息")
    @PreAuthorize("@ss.hasPermi('system:dzbGatheringsCount:query')")
    @GetMapping("/{id}")
    public AjaxResult<TbDzbGatheringsCountVo> getInfo(@NotNull(message = "主键不能为空")
                                                  @PathVariable("id") Long id) {
        return AjaxResult.success(iTbDzbGatheringsCountService.queryById(id));
    }

    /**
     * 新增组织生活会/民主生活会 数据统计
     */
//    @ApiOperation("新增组织生活会/民主生活会 数据统计")
    @PreAuthorize("@ss.hasPermi('system:dzbGatheringsCount:add')")
    @Log(title = "组织生活会/民主生活会 数据统计", businessType = BusinessType.INSERT)
    @RepeatSubmit()
    @PostMapping()
    public AjaxResult<Void> add(@Validated(AddGroup.class) @RequestBody TbDzbGatheringsCountBo bo) {
        return toAjax(iTbDzbGatheringsCountService.insertByBo(bo) ? 1 : 0);
    }

    /**
     * 修改组织生活会/民主生活会 数据统计
     */
//    @ApiOperation("修改组织生活会/民主生活会 数据统计")
    @PreAuthorize("@ss.hasPermi('system:dzbGatheringsCount:edit')")
    @Log(title = "组织生活会/民主生活会 数据统计", businessType = BusinessType.UPDATE)
    @RepeatSubmit()
    @PutMapping()
    public AjaxResult<Void> edit(@Validated(EditGroup.class) @RequestBody TbDzbGatheringsCountBo bo) {
        return toAjax(iTbDzbGatheringsCountService.updateByBo(bo) ? 1 : 0);
    }

}
