package com.ruoyi.system.controller.statistics;

import java.util.List;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

import lombok.RequiredArgsConstructor;

import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.*;

import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.validation.annotation.Validated;
import com.ruoyi.common.annotation.RepeatSubmit;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import com.ruoyi.common.core.validate.QueryGroup;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.system.domain.vo.TbDzbMeetingsCountVo;
import com.ruoyi.system.domain.bo.TbDzbMeetingsCountBo;
import com.ruoyi.system.service.ITbDzbMeetingsCountService;
import com.ruoyi.common.core.page.TableDataInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 三会一课
 * <p>
 * Controller
 *
 * @author ruoyi
 * @date 2021-10-26
 */
@Validated
//@Api(value = "三会一课控制器", tags = {"三会一课管理"})
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@RestController
@RequestMapping("/system/dzbMeetingsCount")
public class TbDzbMeetingsCountController extends BaseController {

    private final ITbDzbMeetingsCountService iTbDzbMeetingsCountService;



    /**
     * 查询三会一课列表
     */
//    @ApiOperation("查询三会一课列表")
    @PreAuthorize("@ss.hasPermi('system:dzbMeetingsCount:list')")
    @GetMapping("/list")
    public TableDataInfo<TbDzbMeetingsCountVo> list(@Validated(QueryGroup.class) TbDzbMeetingsCountBo bo) {
        return iTbDzbMeetingsCountService.queryPageList(bo);
    }

    /**
     * 导出三会一课
     * <p>
     * 列表
     */
//    @ApiOperation("导出三会一课列表")
    @PreAuthorize("@ss.hasPermi('system:dzbMeetingsCount:export')")
    @Log(title = "三会一课", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public void export(@Validated TbDzbMeetingsCountBo bo, HttpServletResponse response) {
        List<TbDzbMeetingsCountVo> list = iTbDzbMeetingsCountService.queryList(bo);
        ExcelUtil.exportExcel(list, "三会一课", TbDzbMeetingsCountVo.class, response);
    }

    /**
     * 获取三会一课详细信息
     */
//    @ApiOperation("获取三会一课详细信息")
    @PreAuthorize("@ss.hasPermi('system:dzbMeetingsCount:query')")
    @GetMapping("/{id}")
    public AjaxResult<TbDzbMeetingsCountVo> getInfo(@NotNull(message = "主键不能为空")
                                                    @PathVariable("id") Long id) {
        return AjaxResult.success(iTbDzbMeetingsCountService.queryById(id));
    }

    /**
     * 新增三会一课
     */
//    @ApiOperation("新增三会一课")
    @PreAuthorize("@ss.hasPermi('system:dzbMeetingsCount:add')")
    @Log(title = "三会一课", businessType = BusinessType.INSERT)
    @RepeatSubmit()
    @PostMapping()
    public AjaxResult<Void> add(@Validated(AddGroup.class) @RequestBody TbDzbMeetingsCountBo bo) {
        return toAjax(iTbDzbMeetingsCountService.insertByBo(bo) ? 1 : 0);
    }

    /**
     * 修改三会一课
     */
//    @ApiOperation("修改三会一课")
    @PreAuthorize("@ss.hasPermi('system:dzbMeetingsCount:edit')")
    @Log(title = "三会一课", businessType = BusinessType.UPDATE)
    @RepeatSubmit()
    @PutMapping()
    public AjaxResult<Void> edit(@Validated(EditGroup.class) @RequestBody TbDzbMeetingsCountBo bo) {
        return toAjax(iTbDzbMeetingsCountService.updateByBo(bo) ? 1 : 0);
    }

}
