package com.ruoyi.system.controller.statistics;

import java.util.List;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import lombok.RequiredArgsConstructor;

import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.*;

import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.validation.annotation.Validated;
import com.ruoyi.common.annotation.RepeatSubmit;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import com.ruoyi.common.core.validate.QueryGroup;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.system.domain.vo.TbDzbReviewConversationCountVo;
import com.ruoyi.system.domain.bo.TbDzbReviewConversationCountBo;
import com.ruoyi.system.service.ITbDzbReviewConversationCountService;
import com.ruoyi.common.core.page.TableDataInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 民主评议/谈心谈话Controller
 *
 * @author ruoyi
 * @date 2021-10-26
 */
@Validated
//@Api(value = "民主评议/谈心谈话控制器", tags = {"民主评议/谈心谈话管理"})
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@RestController
@RequestMapping("/system/dzbReviewConversationCount")
public class TbDzbReviewConversationCountController extends BaseController {

    private final ITbDzbReviewConversationCountService iTbDzbReviewConversationCountService;

//    @ApiOperation("查询民主评议/谈心谈话大屏数据")
    @GetMapping("/getScreen")
    public AjaxResult<List<Map<String, Object>>> getScreen() {
        return AjaxResult.success(iTbDzbReviewConversationCountService.getScreen());
    }

    /**
     * 查询民主评议/谈心谈话列表
     */
//    @ApiOperation("查询民主评议/谈心谈话列表")
    @PreAuthorize("@ss.hasPermi('system:dzbReviewConversationCount:list')")
    @GetMapping("/list")
    public TableDataInfo<TbDzbReviewConversationCountVo> list(@Validated(QueryGroup.class) TbDzbReviewConversationCountBo bo) {
        return iTbDzbReviewConversationCountService.queryPageList(bo);
    }

    /**
     * 导出民主评议/谈心谈话列表
     */
//    @ApiOperation("导出民主评议/谈心谈话列表")
    @PreAuthorize("@ss.hasPermi('system:dzbReviewConversationCount:export')")
    @Log(title = "民主评议/谈心谈话", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public void export(@Validated TbDzbReviewConversationCountBo bo, HttpServletResponse response) {
        List<TbDzbReviewConversationCountVo> list = iTbDzbReviewConversationCountService.queryList(bo);
        ExcelUtil.exportExcel(list, "民主评议/谈心谈话", TbDzbReviewConversationCountVo.class, response);
    }

    /**
     * 获取民主评议/谈心谈话详细信息
     */
//    @ApiOperation("获取民主评议/谈心谈话详细信息")
    @PreAuthorize("@ss.hasPermi('system:dzbReviewConversationCount:query')")
    @GetMapping("/{id}")
    public AjaxResult<TbDzbReviewConversationCountVo> getInfo(@NotNull(message = "主键不能为空")
                                                              @PathVariable("id") Long id) {
        return AjaxResult.success(iTbDzbReviewConversationCountService.queryById(id));
    }

    /**
     * 新增民主评议/谈心谈话
     */
//    @ApiOperation("新增民主评议/谈心谈话")
    @PreAuthorize("@ss.hasPermi('system:dzbReviewConversationCount:add')")
    @Log(title = "民主评议/谈心谈话", businessType = BusinessType.INSERT)
    @RepeatSubmit()
    @PostMapping()
    public AjaxResult<Void> add(@Validated(AddGroup.class) @RequestBody TbDzbReviewConversationCountBo bo) {
        return toAjax(iTbDzbReviewConversationCountService.insertByBo(bo) ? 1 : 0);
    }

    /**
     * 修改民主评议/谈心谈话
     */
//    @ApiOperation("修改民主评议/谈心谈话")
    @PreAuthorize("@ss.hasPermi('system:dzbReviewConversationCount:edit')")
    @Log(title = "民主评议/谈心谈话", businessType = BusinessType.UPDATE)
    @RepeatSubmit()
    @PutMapping()
    public AjaxResult<Void> edit(@Validated(EditGroup.class) @RequestBody TbDzbReviewConversationCountBo bo) {
        return toAjax(iTbDzbReviewConversationCountService.updateByBo(bo) ? 1 : 0);
    }

}
