package com.ruoyi.system.controller.statistics;

import java.util.List;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

import lombok.RequiredArgsConstructor;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.*;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.validation.annotation.Validated;
import com.ruoyi.common.annotation.RepeatSubmit;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import com.ruoyi.common.core.validate.QueryGroup;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.system.domain.vo.TbDzbThemeCountVo;
import com.ruoyi.system.domain.bo.TbDzbThemeCountBo;
import com.ruoyi.system.service.ITbDzbThemeCountService;
import com.ruoyi.common.core.page.TableDataInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 主题党日 数据统计Controller
 *
 * @author ruoyi
 * @date 2021-10-26
 */
@Validated
//@Api(value = "主题党日 数据统计控制器", tags = {"主题党日 数据统计管理"})
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@RestController
@RequestMapping("/system/dzbThemeCount")
public class TbDzbThemeCountController extends BaseController {

    private final ITbDzbThemeCountService iTbDzbThemeCountService;

    /**
     * 查询主题党日 数据统计列表
     */
//    @ApiOperation("查询主题党日 数据统计列表")
    @PreAuthorize("@ss.hasPermi('system:dzbThemeCount:list')")
    @GetMapping("/list")
    public TableDataInfo<TbDzbThemeCountVo> list(@Validated(QueryGroup.class) TbDzbThemeCountBo bo) {
        return iTbDzbThemeCountService.queryPageList(bo);
    }

    /**
     * 导出主题党日 数据统计列表
     */
//    @ApiOperation("导出主题党日 数据统计列表")
    @PreAuthorize("@ss.hasPermi('system:dzbThemeCount:export')")
    @Log(title = "主题党日 数据统计", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public void export(@Validated TbDzbThemeCountBo bo, HttpServletResponse response) {
        List<TbDzbThemeCountVo> list = iTbDzbThemeCountService.queryList(bo);
        ExcelUtil.exportExcel(list, "主题党日 数据统计", TbDzbThemeCountVo.class, response);
    }

    /**
     * 获取主题党日 数据统计详细信息
     */
//    @ApiOperation("获取主题党日 数据统计详细信息")
    @PreAuthorize("@ss.hasPermi('system:dzbThemeCount:query')")
    @GetMapping("/{id}")
    public AjaxResult<TbDzbThemeCountVo> getInfo(@NotNull(message = "主键不能为空")
                                                  @PathVariable("id") Long id) {
        return AjaxResult.success(iTbDzbThemeCountService.queryById(id));
    }

    /**
     * 新增主题党日 数据统计
     */
//    @ApiOperation("新增主题党日 数据统计")
    @PreAuthorize("@ss.hasPermi('system:dzbThemeCount:add')")
    @Log(title = "主题党日 数据统计", businessType = BusinessType.INSERT)
    @RepeatSubmit()
    @PostMapping()
    public AjaxResult<Void> add(@Validated(AddGroup.class) @RequestBody TbDzbThemeCountBo bo) {
        return toAjax(iTbDzbThemeCountService.insertByBo(bo) ? 1 : 0);
    }

    /**
     * 修改主题党日 数据统计
     */
//    @ApiOperation("修改主题党日 数据统计")
    @PreAuthorize("@ss.hasPermi('system:dzbThemeCount:edit')")
    @Log(title = "主题党日 数据统计", businessType = BusinessType.UPDATE)
    @RepeatSubmit()
    @PutMapping()
    public AjaxResult<Void> edit(@Validated(EditGroup.class) @RequestBody TbDzbThemeCountBo bo) {
        return toAjax(iTbDzbThemeCountService.updateByBo(bo) ? 1 : 0);
    }

    /**
     * 删除主题党日 数据统计
     */
//    @ApiOperation("删除主题党日 数据统计")
    @PreAuthorize("@ss.hasPermi('system:dzbThemeCount:remove')")
    @Log(title = "主题党日 数据统计" , businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult<Void> remove(@NotEmpty(message = "主键不能为空")
                                       @PathVariable Long[] ids) {
        return toAjax(iTbDzbThemeCountService.deleteWithValidByIds(Arrays.asList(ids), true) ? 1 : 0);
    }
}
