package com.ruoyi.system.domain;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.util.Date;
import java.math.BigDecimal;

/**
 *  党支部基层数据大屏统计对象 tb_dzb_count
 *
 * @author ruoyi
 * @date 2021-10-26
 */
@Data
@NoArgsConstructor
@Accessors(chain = true)
@TableName("tb_dzb_count")
public class TbDzbCount implements Serializable {

    private static final long serialVersionUID=1L;


    /**
     * 
     */
    @TableId(value = "id")
    private Long id;

    /**
     * 党组织简称
     */
    private String name;

    /**
     * 党支部数
     */
    private Integer dzbCount;

    /**
     * 党员总数
     */
    private Integer dyCount;

    /**
     * 预备党员人数
     */
    private Integer ybdyCount;

    /**
     * 是否显示
     */
    private Integer isShow;

    /**
     * 数据更新时间
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;

}
