package com.ruoyi.system.domain;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.util.Date;
import java.math.BigDecimal;

/**
 * 组织生活会/民主生活会 数据统计对象 tb_dzb_gatherings_count
 *
 * @author ruoyi
 * @date 2021-10-26
 */
@Data
@NoArgsConstructor
@Accessors(chain = true)
@TableName("tb_dzb_gatherings_count")
public class TbDzbGatheringsCount implements Serializable {

    private static final long serialVersionUID=1L;


    /**
     * 
     */
    @TableId(value = "id")
    private Long id;

    /**
     * 组织名称
     */
    private String name;

    /**
     * 累计开展次数
     */
    private Integer totalCount;

    /**
     * 平均时长
     */
    private Integer avgDuration;

    /**
     * 到会率
     */
    private Integer attendanceRate;

    /**
     * 请假率
     */
    private Integer leaveRate;

    /**
     * 查摆问题数
     */
    private Integer problemsCount;

    /**
     * 批评与自我批评数
     */
    private Integer criticismCount;

    /**
     * 整改措施数
     */
    private Integer rectificationCount;

    /**
     * 整改完成情况
     */
    private Integer completionRate;

    /**
     * 数据更新时间
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;

}
