package com.ruoyi.system.domain;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.util.Date;
import java.math.BigDecimal;

/**
 * 三会一课

对象 tb_dzb_meetings_count
 *
 * @author ruoyi
 * @date 2021-10-26
 */
@Data
@NoArgsConstructor
@Accessors(chain = true)
@TableName("tb_dzb_meetings_count")
public class TbDzbMeetingsCount implements Serializable {

    private static final long serialVersionUID=1L;


    /**
     * 
     */
    @TableId(value = "id")
    private Long id;

    /**
     * 组织名称
     */
    private String name;

    /**
     * 类型（frequency:开展频次，activityContent:活动内容，attendanceRate：到会率，leaveRate：请假率）
     */
    private String type;

    /**
     * 会议名称/XX名字
     */
    private String childName;

    /**
     * 对应值
     */
    private Integer value;

    /**
     * 编号
     */
    private String number;

    /**
     * 数据更新时间
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;

}
