package com.ruoyi.system.domain;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.util.Date;
import java.math.BigDecimal;

/**
 * 民主评议/谈心谈话对象 tb_dzb_review_conversation_count
 *
 * @author ruoyi
 * @date 2021-10-26
 */
@Data
@NoArgsConstructor
@Accessors(chain = true)
@TableName("tb_dzb_review_conversation_count")
public class TbDzbReviewConversationCount implements Serializable {

    private static final long serialVersionUID=1L;


    /**
     * 
     */
    @TableId(value = "id")
    private Long id;

    /**
     * 组织名称
     */
    private String name;

    /**
     * 优秀率
     */
    private Integer excellentRate;

    /**
     * 合格率
     */
    private Integer qualifiedRate;

    /**
     * 基本合格率
     */
    private Integer basicQualifiedRate;

    /**
     * 不合格率
     */
    private Integer unqualifiedRate;

    /**
     * 书记与委员谈话数
     */
    private Integer swCount;

    /**
     * 委员与委员谈话数
     */
    private Integer wwCount;

    /**
     * 委员与党员谈话数
     */
    private Integer wdCount;

    /**
     * 党员与党员谈话数
     */
    private Integer ddCount;

    /**
     * 
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;

}
