package com.ruoyi.system.domain;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.util.Date;
import java.math.BigDecimal;

/**
 * 主题党日 数据统计对象 tb_dzb_theme_count
 *
 * @author ruoyi
 * @date 2021-10-26
 */
@Data
@NoArgsConstructor
@Accessors(chain = true)
@TableName("tb_dzb_theme_count")
public class TbDzbThemeCount implements Serializable {

    private static final long serialVersionUID=1L;


    /**
     * 
     */
    @TableId(value = "id")
    private Long id;

    /**
     * 组织名字
     */
    private String name;

    /**
     * 开展频次
     */
    private Integer frequency;

    /**
     * 平均时长
     */
    private Integer avgDuration;

    /**
     * 到会率
     */
    private Integer attendanceRate;

    /**
     * 请假率
     */
    private Integer leaveRate;

    /**
     * 数据更新时间
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;

}
