package com.ruoyi.system.domain;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.util.Date;
import java.math.BigDecimal;

/**
 * 活动详情主体对象 zk_activity_info
 *
 * @author ruoyi
 * @date 2021-10-27
 */
@Data
@NoArgsConstructor
@Accessors(chain = true)
@TableName("zk_activity_info")
public class ZkActivityInfo implements Serializable {

    private static final long serialVersionUID=1L;


    /**
     *
     */
    @TableId(value = "id")
    private Long id;

    /**
     *
     */
    private Long pActivityId;

    /**
     * zk_activity_type表对应id
     */
    private Long titleType;

    /**
     * 参加党支部部门id
     */
    private String deptIds;

    /**
     * 参加党支部部门id
     */
    private String theme;

    /**
     * 活动类型
     */
    private String type;
    private String typeName;

    /**
     * 活动标签（党支部名称+活动时间）
     */
    private String activityLabel;

    /**
     * 活动时间
     */
    private Date activityDate;

    /**
     * 活动地址
     */
    private String address;

    /**
     * 主持人
     */
    private String hostUser;

    /**
     * 记录人
     */
    private String recorder;

    /**
     * 列席人员
     */
    private String nvPersonnel;

    /**
     * 活动时长
     */
    private Integer duration;

    /**
     * 活动照片
     */
    private String photo;

    /**
     *
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     *
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;

    /**
     *
     */
    private String lastUpdateUser;

    /**
     * 发布主体id
     */
    private Long pDeptId;

    /**
     * 发布主体
     */
    private String pDeptName;

    /**
     * 发布时间
     */
    private Date releaseTime;

    /**
     * 活动截至时间
     */
    private Date overTime;

    /**
     * 活动开展时间
     */
    private Date executionTime;

    /**
     * 活动状态（0：未完成；1：已完成）
     */
    private Integer status;


    /**
     * 活动状态（0：未完成；1：已完成）
     */
    private Integer isDel;


    /**
     * 专项活动推送状态
     */
    private Integer pushStatus;


    /**
     * 主讲人
     */
    private String speaker;

    /**
     * 活动状态（0：未完成；1：已完成）
     */
    private String speakerJob;


    /**
     * 发布主体
     */
    private Long subjectDeptId;

    /**
     * 发布主体活动id
     */
    private Long subjectActivityId;

    /**
     * 到会率
     */
    private String attendanceRate;

    /**
     * 请假率
     */
    private String leaveRate;

}
