package com.ruoyi.system.domain.bo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel(value = "活动列表查询对象")
public class ActivityInfoBo {

    @ApiModelProperty("查询")
    private String search;

    @ApiModelProperty("列表类型（1：组织活动；2：民主评议；4：专项活动）")
    private Integer titleType;

    @ApiModelProperty("活动类型")
    private String type;

    @ApiModelProperty("活动内容Key")
    private String contentKey;

    @ApiModelProperty("部门id")
    private String deptId;

    /**
     * 分页大小
     */
    @ApiModelProperty("分页大小")
    private Integer pageSize = 10;

    /**
     * 当前页数
     */
    @ApiModelProperty("当前页数")
    private Integer pageNum = 1;

}
