package com.ruoyi.system.domain.bo;

import com.ruoyi.common.core.domain.BaseEntity;
import com.ruoyi.system.domain.ZkActivityEvaluate;
import com.ruoyi.system.domain.vo.ZkActivityEvaluateForAddVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 活动详情主体业务对象 zk_activity_info
 *
 * @author ruoyi
 * @date 2021-10-27
 */

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel("活动详情主体业务对象")
public class OrganizationalActivityBo extends BaseEntity {

    /**
     *
     */
    @ApiModelProperty(value = "")
    private Long id;

    /**
     * 参加党支部部门id
     */
    @ApiModelProperty(value = "参加党支部部门id")
    private String deptIds;

    /**
     * 参加党支部部门id
     */
    @ApiModelProperty(value = "活动主题")
    private String theme;

    /**
     * 活动类型
     */
    @ApiModelProperty(value = "活动类型")
    private String type;

    /**
     * 活动标签（党支部名称+活动时间）
     */
    @ApiModelProperty(value = "活动标签（党支部名称+活动时间）")
    private String activityLabel;

    /**
     * 活动时间
     */
    @ApiModelProperty(value = "活动时间")
    private String activityDate;

    /**
     * 活动地址
     */
    @ApiModelProperty(value = "活动地址")
    private String address;

    /**
     * 主持人
     */
    @ApiModelProperty(value = "主持人")
    private String hostUser;

    /**
     * 记录人
     */
    @ApiModelProperty(value = "记录人")
    private String recorder;

    /**
     * 列席人员
     */
    @ApiModelProperty(value = "列席人员")
    private String nvPersonnel;

    /**
     * 活动时长
     */
    @ApiModelProperty(value = "活动时长")
    private Integer duration;

    /**
     * 活动照片
     */
    @ApiModelProperty(value = "活动照片")
    private String photo;

    /**
     * 创建人
     */
    @ApiModelProperty(value = "创建人")
    private String createUser;

    /**
     *
     */
    @ApiModelProperty(value = "")
    private String lastUpdateUser;

    /**
     * 发布主体
     */
    @ApiModelProperty(value = "发布主体")
    private String pDeptName;

    /**
     * 发布主体
     */
    @ApiModelProperty(value = "发布主体Id")
    private Long pDeptId;

    /**
     * 发布时间
     */
    @ApiModelProperty(value = "发布时间")
    private String releaseTime;

    /**
     * 活动截至时间
     */
    @ApiModelProperty(value = "活动截至时间")
    private String overTime;

    /**
     * 活动开展时间
     */
    @ApiModelProperty(value = "活动开展时间")
    private String executionTime;

    /**
     * 活动状态（0：未完成；1：已完成）
     */
    @ApiModelProperty(value = "活动状态（0：未完成；1：已完成）")
    private Integer status;

    @ApiModelProperty(value = "活动对象列表")
    private List<ZkActivityObjForAddBo> objBos;

    @ApiModelProperty(value = "活动内容列表")
    private List<ZkActivityInfoContentForAddBo> contents;

    /**
     * 主讲人
     */
    @ApiModelProperty(value = "主讲人")
    private String speaker;

    /**
     * 活动状态（0：未完成；1：已完成）
     */
    @ApiModelProperty(value = "主讲人职务")
    private String speakerJob;

    @ApiModelProperty(value = "主讲人职务")
    private Long titleType;

    @ApiModelProperty("按钮类型（1执行，2编辑）")
    private Integer buttonType;

    @ApiModelProperty("组织评定列表")
    private List<ZkActivityEvaluateForAddVo> evaluate;

}
