package com.ruoyi.system.domain.bo;

import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import javax.validation.constraints.*;

import java.util.Date;

import com.ruoyi.common.core.domain.BaseEntity;

/**
 *  党支部基层数据大屏统计业务对象 tb_dzb_count
 *
 * @author ruoyi
 * @date 2021-10-26
 */

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(" 党支部基层数据大屏统计业务对象")
public class TbDzbCountBo extends BaseEntity {

    /**
     * 
     */
    @ApiModelProperty(value = "")
    private Long id;

    /**
     * 党组织简称
     */
    @ApiModelProperty(value = "党组织简称", required = true)
    @NotBlank(message = "党组织简称不能为空", groups = { AddGroup.class, EditGroup.class })
    private String name;

    /**
     * 党支部数
     */
    @ApiModelProperty(value = "党支部数", required = true)
    @NotNull(message = "党支部数不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer dzbCount;

    /**
     * 党员总数
     */
    @ApiModelProperty(value = "党员总数", required = true)
    @NotNull(message = "党员总数不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer dyCount;

    /**
     * 预备党员人数
     */
    @ApiModelProperty(value = "预备党员人数", required = true)
    @NotNull(message = "预备党员人数不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer ybdyCount;

    /**
     * 是否显示
     */
    @ApiModelProperty(value = "是否显示", required = true)
    @NotNull(message = "是否显示不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer isShow;


    /**
     * 分页大小
     */
    @ApiModelProperty("分页大小")
    private Integer pageSize;

    /**
     * 当前页数
     */
    @ApiModelProperty("当前页数")
    private Integer pageNum;

    /**
     * 排序列
     */
    @ApiModelProperty("排序列")
    private String orderByColumn;

    /**
     * 排序的方向desc或者asc
     */
    @ApiModelProperty(value = "排序的方向", example = "asc,desc")
    private String isAsc;

}
