package com.ruoyi.system.domain.bo;

import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import javax.validation.constraints.*;

import java.util.Date;

import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 组织生活会/民主生活会 数据统计业务对象 tb_dzb_gatherings_count
 *
 * @author ruoyi
 * @date 2021-10-26
 */

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel("组织生活会/民主生活会 数据统计业务对象")
public class TbDzbGatheringsCountBo extends BaseEntity {

    /**
     * 
     */
    @ApiModelProperty(value = "")
    private Long id;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称", required = true)
    @NotBlank(message = "组织名称不能为空", groups = { AddGroup.class, EditGroup.class })
    private String name;

    /**
     * 累计开展次数
     */
    @ApiModelProperty(value = "累计开展次数", required = true)
    @NotNull(message = "累计开展次数不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer totalCount;

    /**
     * 平均时长
     */
    @ApiModelProperty(value = "平均时长", required = true)
    @NotNull(message = "平均时长不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer avgDuration;

    /**
     * 到会率
     */
    @ApiModelProperty(value = "到会率", required = true)
    @NotNull(message = "到会率不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer attendanceRate;

    /**
     * 请假率
     */
    @ApiModelProperty(value = "请假率", required = true)
    @NotNull(message = "请假率不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer leaveRate;

    /**
     * 查摆问题数
     */
    @ApiModelProperty(value = "查摆问题数", required = true)
    @NotNull(message = "查摆问题数不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer problemsCount;

    /**
     * 批评与自我批评数
     */
    @ApiModelProperty(value = "批评与自我批评数", required = true)
    @NotNull(message = "批评与自我批评数不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer criticismCount;

    /**
     * 整改措施数
     */
    @ApiModelProperty(value = "整改措施数", required = true)
    @NotNull(message = "整改措施数不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer rectificationCount;

    /**
     * 整改完成情况
     */
    @ApiModelProperty(value = "整改完成情况", required = true)
    @NotNull(message = "整改完成情况不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer completionRate;


    /**
     * 分页大小
     */
    @ApiModelProperty("分页大小")
    private Integer pageSize;

    /**
     * 当前页数
     */
    @ApiModelProperty("当前页数")
    private Integer pageNum;

    /**
     * 排序列
     */
    @ApiModelProperty("排序列")
    private String orderByColumn;

    /**
     * 排序的方向desc或者asc
     */
    @ApiModelProperty(value = "排序的方向", example = "asc,desc")
    private String isAsc;

}
