package com.ruoyi.system.domain.bo;

import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.*;

import java.util.Date;

import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 三会一课
 * <p>
 * 业务对象 tb_dzb_meetings_count
 *
 * @author ruoyi
 * @date 2021-10-26
 */

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel("三会一课业务对象")
public class TbDzbMeetingsCountBo extends BaseEntity {

    /**
     *
     */
    @ApiModelProperty(value = "")
    private Long id;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称", required = true)
    @NotBlank(message = "组织名称不能为空", groups = {AddGroup.class, EditGroup.class})
    private String name;

    /**
     * 类型（frequency:开展频次，activityContent:活动内容，attendanceRate：到会率，leaveRate：请假率）
     */
    @ApiModelProperty(value = "类型（frequency:开展频次，activityContent:活动内容，attendanceRate：到会率，leaveRate：请假率）", required = true)
    @NotBlank(message = "类型（frequency:开展频次，activityContent:活动内容，attendanceRate：到会率，leaveRate：请假率）不能为空", groups = {AddGroup.class, EditGroup.class})
    private String type;

    /**
     * 会议名称/XX名字
     */
    @ApiModelProperty(value = "会议名称/XX名字", required = true)
    @NotBlank(message = "会议名称/XX名字不能为空", groups = {AddGroup.class, EditGroup.class})
    private String childName;

    /**
     * 对应值
     */
    @ApiModelProperty(value = "对应值", required = true)
    @NotNull(message = "对应值不能为空", groups = {AddGroup.class, EditGroup.class})
    private Integer value;

    /**
     * 编号
     */
    @ApiModelProperty(value = "编号")
    private String number;


    /**
     * 分页大小
     */
    @ApiModelProperty("分页大小")
    private Integer pageSize;

    /**
     * 当前页数
     */
    @ApiModelProperty("当前页数")
    private Integer pageNum;

    /**
     * 排序列
     */
    @ApiModelProperty("排序列")
    private String orderByColumn;

    /**
     * 排序的方向desc或者asc
     */
    @ApiModelProperty(value = "排序的方向", example = "asc,desc")
    private String isAsc;

}
