package com.ruoyi.system.domain.bo;

import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import javax.validation.constraints.*;

import java.util.Date;

import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 民主评议/谈心谈话业务对象 tb_dzb_review_conversation_count
 *
 * @author ruoyi
 * @date 2021-10-26
 */

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel("民主评议/谈心谈话业务对象")
public class TbDzbReviewConversationCountBo extends BaseEntity {

    /**
     * 
     */
    @ApiModelProperty(value = "")
    private Long id;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称", required = true)
    @NotBlank(message = "组织名称不能为空", groups = { AddGroup.class, EditGroup.class })
    private String name;

    /**
     * 优秀率
     */
    @ApiModelProperty(value = "优秀率", required = true)
    @NotNull(message = "优秀率不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer excellentRate;

    /**
     * 合格率
     */
    @ApiModelProperty(value = "合格率", required = true)
    @NotNull(message = "合格率不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer qualifiedRate;

    /**
     * 基本合格率
     */
    @ApiModelProperty(value = "基本合格率", required = true)
    @NotNull(message = "基本合格率不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer basicQualifiedRate;

    /**
     * 不合格率
     */
    @ApiModelProperty(value = "不合格率", required = true)
    @NotNull(message = "不合格率不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer unqualifiedRate;

    /**
     * 书记与委员谈话数
     */
    @ApiModelProperty(value = "书记与委员谈话数", required = true)
    @NotNull(message = "书记与委员谈话数不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer swCount;

    /**
     * 委员与委员谈话数
     */
    @ApiModelProperty(value = "委员与委员谈话数", required = true)
    @NotNull(message = "委员与委员谈话数不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer wwCount;

    /**
     * 委员与党员谈话数
     */
    @ApiModelProperty(value = "委员与党员谈话数", required = true)
    @NotNull(message = "委员与党员谈话数不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer wdCount;

    /**
     * 党员与党员谈话数
     */
    @ApiModelProperty(value = "党员与党员谈话数", required = true)
    @NotNull(message = "党员与党员谈话数不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer ddCount;


    /**
     * 分页大小
     */
    @ApiModelProperty("分页大小")
    private Integer pageSize;

    /**
     * 当前页数
     */
    @ApiModelProperty("当前页数")
    private Integer pageNum;

    /**
     * 排序列
     */
    @ApiModelProperty("排序列")
    private String orderByColumn;

    /**
     * 排序的方向desc或者asc
     */
    @ApiModelProperty(value = "排序的方向", example = "asc,desc")
    private String isAsc;

}
