package com.ruoyi.system.domain.bo;

import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import javax.validation.constraints.*;

import java.util.Date;

import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 主题党日 数据统计业务对象 tb_dzb_theme_count
 *
 * @author ruoyi
 * @date 2021-10-26
 */

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel("主题党日 数据统计业务对象")
public class TbDzbThemeCountBo extends BaseEntity {

    /**
     * 
     */
    @ApiModelProperty(value = "")
    private Long id;

    /**
     * 组织名字
     */
    @ApiModelProperty(value = "组织名字", required = true)
    @NotBlank(message = "组织名字不能为空", groups = { AddGroup.class, EditGroup.class })
    private String name;

    /**
     * 开展频次
     */
    @ApiModelProperty(value = "开展频次", required = true)
    @NotNull(message = "开展频次不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer frequency;

    /**
     * 平均时长
     */
    @ApiModelProperty(value = "平均时长", required = true)
    @NotNull(message = "平均时长不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer avgDuration;

    /**
     * 到会率
     */
    @ApiModelProperty(value = "到会率", required = true)
    @NotNull(message = "到会率不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer attendanceRate;

    /**
     * 请假率
     */
    @ApiModelProperty(value = "请假率", required = true)
    @NotNull(message = "请假率不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer leaveRate;


    /**
     * 分页大小
     */
    @ApiModelProperty("分页大小")
    private Integer pageSize;

    /**
     * 当前页数
     */
    @ApiModelProperty("当前页数")
    private Integer pageNum;

    /**
     * 排序列
     */
    @ApiModelProperty("排序列")
    private String orderByColumn;

    /**
     * 排序的方向desc或者asc
     */
    @ApiModelProperty(value = "排序的方向", example = "asc,desc")
    private String isAsc;

}
