package com.ruoyi.system.domain.bo;

import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import javax.validation.constraints.*;

import java.util.Date;

import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 组织评定业务对象 zk_activity_evaluate
 *
 * @author ruoyi
 * @date 2021-11-10
 */

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel("组织评定业务对象")
public class ZkActivityEvaluateBo extends BaseEntity {

    /**
     * 
     */
    @ApiModelProperty(value = "")
    private Long id;

    /**
     * 活动id
     */
    @ApiModelProperty(value = "活动id")
    private Long activityId;

    /**
     * 
     */
    @ApiModelProperty(value = "")
    private Long userId;

    /**
     * 党员姓名
     */
    @ApiModelProperty(value = "党员姓名")
    private String userName;

    /**
     * 0,1,2,3
     */
    @ApiModelProperty(value = "0,1,2,3")
    private Integer evaluateType;

    /**
     * 是否进行口头表扬
     */
    @ApiModelProperty(value = "是否进行口头表扬")
    private Integer isPraise;

    /**
     * 不合格值
     */
    @ApiModelProperty(value = "不合格值")
    private String unqualified;


    /**
     * 分页大小
     */
    @ApiModelProperty("分页大小")
    private Integer pageSize;

    /**
     * 当前页数
     */
    @ApiModelProperty("当前页数")
    private Integer pageNum;

    /**
     * 排序列
     */
    @ApiModelProperty("排序列")
    private String orderByColumn;

    /**
     * 排序的方向desc或者asc
     */
    @ApiModelProperty(value = "排序的方向", example = "asc,desc")
    private String isAsc;

}
