package com.ruoyi.system.domain.bo;

import com.fasterxml.jackson.annotation.JsonFormat;

import com.ruoyi.common.core.validate.QueryGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * 活动详情主体业务对象 zk_activity_info
 *
 * @author ruoyi
 * @date 2021-10-27
 */

@Data
@ApiModel("活动详情主体业务对象")
public class ZkActivityInfoBo2 {



    /**
     * 活动类型
     */
    @ApiModelProperty(value = "活动类型")
    private String type;


    /**
     * 活动开展时间开始
     */
    @ApiModelProperty(value = "活动开展时间开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startExecutionTime;

    /**
     * 活动开展时间结束
     */
    @ApiModelProperty(value = "活动开展时间结束")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endExecutionTime;

    /**
     * 活动时长开始
     */
    @ApiModelProperty(value = "活动时长开始")
    private Integer durationStart;

    /**
     * 活动时长结束
     */
    @ApiModelProperty(value = "活动时长结束")
    private Integer durationEnd;

    @ApiModelProperty(value = "部门id")
    private String deptId;


    @ApiModelProperty(value = "部门id")
    private List<String> deptIDS;
    /**
     * 活动对象id
     */
    @ApiModelProperty(value = "活动对象id")
    private Integer activityObjId;

    /**
     * 活动内容id
     */
    @ApiModelProperty(value = "活动内容id")
    private Integer activityContentId;

    /**
     * 到会率开始
     */
    @ApiModelProperty(value = "到会率开始")
    private String attendanceRateStart;
    /**
     * 到会率结束
     */
    @ApiModelProperty(value = "到会率结束")
    private String attendanceRateEnd;
    /**
     * 缺席率开始
     */
    @ApiModelProperty(value = "缺席率开始")
    private String absentRateStart;
    /**
     * 缺席率结束
     */
    @ApiModelProperty(value = "缺席率结束")
    private String absentRateEnd;

    /**
     * 请假率开始
     */
    @ApiModelProperty(value = "请假率开始")
    private String leaveRateStart;
    /**
     * 请假率结束
     */
    @ApiModelProperty(value = "请假率结束")
    private String leaveRateEnd;


    /**
     * 分页大小
     */
    @ApiModelProperty(value = "分页大小", required = true)
    @NotNull(message = "pageSize不能为空", groups = { QueryGroup.class })
    private Integer pageSize;

    /**
     * 当前页数
     */
    @ApiModelProperty(value = "当前页数", required = true)
    @NotNull(message = "pageNum不能为空", groups = { QueryGroup.class })
    private Integer pageNum;

}
