package com.ruoyi.system.domain.bo;

import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import javax.validation.constraints.*;

import java.util.Date;

import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 【请填写功能名称】业务对象 zk_activity_info_content
 *
 * @author ruoyi
 * @date 2021-10-27
 */

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel("【请填写功能名称】业务对象")
public class ZkActivityInfoContentBo extends BaseEntity {

    /**
     * 
     */
    @ApiModelProperty(value = "")
    private Long id;

    /**
     * activity_info_id
     */
    @ApiModelProperty(value = "activity_info_id", required = true)
    @NotNull(message = "activity_info_id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long activityId;

    /**
     * activity_content_name
     */
    @ApiModelProperty(value = "activity_content_name")
    private String contentName;

    /**
     * activity_content_key
     */
    @ApiModelProperty(value = "activity_content_key")
    private String contentKey;

    /**
     * 内容正文
     */
    @ApiModelProperty(value = "内容正文")
    private String content;


    /**
     * 分页大小
     */
    @ApiModelProperty("分页大小")
    private Integer pageSize;

    /**
     * 当前页数
     */
    @ApiModelProperty("当前页数")
    private Integer pageNum;

    /**
     * 排序列
     */
    @ApiModelProperty("排序列")
    private String orderByColumn;

    /**
     * 排序的方向desc或者asc
     */
    @ApiModelProperty(value = "排序的方向", example = "asc,desc")
    private String isAsc;

}
