package com.ruoyi.system.domain.bo;

import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import javax.validation.constraints.*;

import java.util.Date;

import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 活动主体中的活动对象业务对象 zk_activity_obj
 *
 * @author ruoyi
 * @date 2021-10-27
 */

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel("活动主体中的活动对象业务对象")
public class ZkActivityObjBo extends BaseEntity {

    /**
     *
     */
    @ApiModelProperty(value = "")
    private Long id;

    /**
     * 对应活动id
     */
    @ApiModelProperty(value = "对应活动id", required = true)
    @NotNull(message = "对应活动id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long activityId;

    /**
     * 活动对象标签名称
     */
    @ApiModelProperty(value = "活动对象标签名称")
    private String label;

    /**
     * 活动对象Key
     */
    @ApiModelProperty(value = "活动对象Key")
    private String objKey;

    /**
     * 活动对象value
     */
    @ApiModelProperty(value = "活动对象value")
    private String objValue;

    /**
     * 删除状态
     */
    @ApiModelProperty(value = "删除状态")
    private Integer isDel;


    /**
     * 分页大小
     */
    @ApiModelProperty("分页大小")
    private Integer pageSize;

    /**
     * 当前页数
     */
    @ApiModelProperty("当前页数")
    private Integer pageNum;

    /**
     * 排序列
     */
    @ApiModelProperty("排序列")
    private String orderByColumn;

    /**
     * 排序的方向desc或者asc
     */
    @ApiModelProperty(value = "排序的方向", example = "asc,desc")
    private String isAsc;

}
