package com.ruoyi.system.domain.bo;

import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import javax.validation.constraints.*;

import java.util.Date;

import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 活动对象人员信息业务对象 zk_activity_obj_user
 *
 * @author ruoyi
 * @date 2021-11-02
 */

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel("活动对象人员信息业务对象")
public class ZkActivityObjUserBo extends BaseEntity {

    /**
     *
     */
    @ApiModelProperty(value = "")
    private Long id;

    /**
     * 活动id
     */
    @ApiModelProperty(value = "活动id")
    private Long activityId;

    @ApiModelProperty(value = "活动对象id")
    private Long activityObjId;

    /**
     * 人员类型（0正常，1缺席，2请假）
     */
    @ApiModelProperty(value = "人员类型（0正常，1缺席，2请假）")
    private Long type;

    /**
     *
     */
    @ApiModelProperty(value = "")
    private Long userId;

    /**
     * 人员名字
     */
    @ApiModelProperty(value = "人员名字")
    private String userName;


    /**
     * 分页大小
     */
    @ApiModelProperty("分页大小")
    private Integer pageSize;

    /**
     * 当前页数
     */
    @ApiModelProperty("当前页数")
    private Integer pageNum;

    /**
     * 排序列
     */
    @ApiModelProperty("排序列")
    private String orderByColumn;

    /**
     * 排序的方向desc或者asc
     */
    @ApiModelProperty(value = "排序的方向", example = "asc,desc")
    private String isAsc;

}
