package com.ruoyi.system.domain.bo;

import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import javax.validation.constraints.*;

import java.util.Date;

import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 活动类型业务对象 zk_activity_type
 *
 * @author ruoyi
 * @date 2021-11-03
 */

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel("活动类型业务对象")
public class ZkActivityTypeBo extends BaseEntity {

    /**
     * 
     */
    @ApiModelProperty(value = "")
    private Long id;

    /**
     * type显示文字
     */
    @ApiModelProperty(value = "type显示文字")
    private String type;

    /**
     * type值value
     */
    @ApiModelProperty(value = "type值value")
    private String typeValue;


    /**
     * 分页大小
     */
    @ApiModelProperty("分页大小")
    private Integer pageSize;

    /**
     * 当前页数
     */
    @ApiModelProperty("当前页数")
    private Integer pageNum;

    /**
     * 排序列
     */
    @ApiModelProperty("排序列")
    private String orderByColumn;

    /**
     * 排序的方向desc或者asc
     */
    @ApiModelProperty(value = "排序的方向", example = "asc,desc")
    private String isAsc;

}
