package com.ruoyi.system.domain.bo;

import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import javax.validation.constraints.*;

import java.util.Date;

import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 活动类型与活动内容关联业务对象 zk_activity_type_content
 *
 * @author ruoyi
 * @date 2021-10-27
 */

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel("活动类型与活动内容关联业务对象")
public class ZkActivityTypeContentBo extends BaseEntity {

    /**
     * 
     */
    @ApiModelProperty(value = "")
    private Long id;

    /**
     * 活动分类
     */
    @ApiModelProperty(value = "活动分类")
    private String type;

    /**
     * 活动id（1，2）
     */
    @ApiModelProperty(value = "活动id（1，2）")
    private String contentIds;

    /**
     * 删除标识
     */
    @ApiModelProperty(value = "删除标识")
    private Integer isDel;


    /**
     * 分页大小
     */
    @ApiModelProperty("分页大小")
    private Integer pageSize;

    /**
     * 当前页数
     */
    @ApiModelProperty("当前页数")
    private Integer pageNum;

    /**
     * 排序列
     */
    @ApiModelProperty("排序列")
    private String orderByColumn;

    /**
     * 排序的方向desc或者asc
     */
    @ApiModelProperty(value = "排序的方向", example = "asc,desc")
    private String isAsc;

}
