package com.ruoyi.system.domain.vo;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.ruoyi.common.core.domain.TreeSelect;
import com.ruoyi.common.core.domain.entity.SysDept;
import lombok.Data;

import java.util.List;
import java.util.stream.Collectors;

@Data
public class DeptTreeVo {

    /** 节点ID */
    private Long deptId;

    /** 节点名称 */
    private String deptName;

    /** 地点标识 */
    private String addressAbb;

    /** 子节点 */
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<DeptTreeVo> children;

    public DeptTreeVo(SysDept dept)
    {
        this.deptId = dept.getDeptId();
        this.deptName = dept.getDeptName();
        this.addressAbb = dept.getAddressAbb();
        this.children = dept.getChildren().stream().map(DeptTreeVo::new).collect(Collectors.toList());
    }

}
