package com.ruoyi.system.domain.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
@ApiModel(value = "组织活动列表对象")
public class OrganizationalActivityInfoVo {

    @ApiModelProperty("序号")
    private Long id;

    @ApiModelProperty("活动标签")
    private String activityLabel;

    @ApiModelProperty("活动地点")
    private String address;

    @ApiModelProperty("活动类型")
    private String type;

    @ApiModelProperty("活动类型名称")
    private String typeName;

    @ApiModelProperty("活动对象")
    private String activityObjs;

    @ApiModelProperty("活动内容")
    private String content;

    @ApiModelProperty("到会率")
    private String attendanceRate;

    @ApiModelProperty(value = "已参加人员")
    private String participatedUser;

    @ApiModelProperty(value = "请假人员")
    private String leaveUser;

    @ApiModelProperty(value = "无故缺席人员")
    private String absentUser;

    @ApiModelProperty(value = "不计入应到会人员")
    private String unUser;

    @ApiModelProperty(value = "流动党员")
    private String ldUser;

    @ApiModelProperty(value = "部门名称")
    private String deptName;

    @ApiModelProperty(value = "活动时间")
    private String activityDate;

    @ApiModelProperty(value = "活动部门id")
    private Long pDeptId;

    @ApiModelProperty("组织评定列表")
    private List<ZkActivityEvaluateForAddVo> evaluate;

}
