package com.ruoyi.system.domain.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
@ApiModel(value = "专项活动列表对象")
public class SpecialActivityInfoVo {

    @ApiModelProperty("序号")
    private Long id;

    @ApiModelProperty("活动标签")
    private String activityLabel;

    @ApiModelProperty("活动主题")
    private String theme;

    @ApiModelProperty("活动类型Key")
    private String type;
    @ApiModelProperty("活动类型")
    private String typeName;

    @ApiModelProperty("活动内容Key")
    private String contentKey;

    @ApiModelProperty("活动内容")
    private String contentName;

    @ApiModelProperty("活动内容说明")
    private String content;

    @ApiModelProperty("发布主体")
    private String pDeptName;

    @ApiModelProperty("发布时间")
    private Date releaseTime;

    @ApiModelProperty("完成截至时间")
    private Date overTime;

    @ApiModelProperty("活动开展时间")
    private Date executionTime;

    @ApiModelProperty("活动开展时间")
    private Integer status;

    @ApiModelProperty("未完成列表")
    private List<SpecialActivityCountVo> deptList;

    @ApiModelProperty("发布主体id")
    private Long subjectDeptId;

    @ApiModelProperty("是否可执行（0，否，1是）")
    private Integer isImplement;

    @ApiModelProperty("是否可取消发布（0，否，1是）")
    private Integer isCancel;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("完成数量")
    private Long overCount;

}
