package com.ruoyi.system.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.ruoyi.common.annotation.ExcelDictFormat;
import com.ruoyi.common.convert.ExcelDictConvert;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.util.Date;



/**
 *  党支部基层数据大屏统计视图对象 tb_dzb_count
 *
 * @author ruoyi
 * @date 2021-10-26
 */
@Data
@ApiModel(" 党支部基层数据大屏统计视图对象")
@ExcelIgnoreUnannotated
public class TbDzbCountVo {

	private static final long serialVersionUID = 1L;

	/**
     *  
     */
	@ApiModelProperty("")
	private Long id;

    /**
     * 党组织简称
     */
	@ExcelProperty(value = "党组织简称")
	@ApiModelProperty("党组织简称")
	private String name;

    /**
     * 党支部数
     */
	@ExcelProperty(value = "党支部数")
	@ApiModelProperty("党支部数")
	private Integer dzbCount;

    /**
     * 党员总数
     */
	@ExcelProperty(value = "党员总数")
	@ApiModelProperty("党员总数")
	private Integer dyCount;

    /**
     * 预备党员人数
     */
	@ExcelProperty(value = "预备党员人数")
	@ApiModelProperty("预备党员人数")
	private Integer ybdyCount;

    /**
     * 是否显示
     */
	@ExcelProperty(value = "是否显示")
	@ApiModelProperty("是否显示")
	private Integer isShow;


}
