package com.ruoyi.system.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.ruoyi.common.annotation.ExcelDictFormat;
import com.ruoyi.common.convert.ExcelDictConvert;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.util.Date;



/**
 * 组织生活会/民主生活会 数据统计视图对象 tb_dzb_gatherings_count
 *
 * @author ruoyi
 * @date 2021-10-26
 */
@Data
@ApiModel("组织生活会/民主生活会 数据统计视图对象")
@ExcelIgnoreUnannotated
public class TbDzbGatheringsCountVo {

	private static final long serialVersionUID = 1L;

	/**
     *  
     */
	@ApiModelProperty("")
	private Long id;

    /**
     * 组织名称
     */
	@ExcelProperty(value = "组织名称")
	@ApiModelProperty("组织名称")
	private String name;

    /**
     * 累计开展次数
     */
	@ExcelProperty(value = "累计开展次数")
	@ApiModelProperty("累计开展次数")
	private Integer totalCount;

    /**
     * 平均时长
     */
	@ExcelProperty(value = "平均时长")
	@ApiModelProperty("平均时长")
	private Integer avgDuration;

    /**
     * 到会率
     */
	@ExcelProperty(value = "到会率")
	@ApiModelProperty("到会率")
	private Integer attendanceRate;

    /**
     * 请假率
     */
	@ExcelProperty(value = "请假率")
	@ApiModelProperty("请假率")
	private Integer leaveRate;

    /**
     * 查摆问题数
     */
	@ExcelProperty(value = "查摆问题数")
	@ApiModelProperty("查摆问题数")
	private Integer problemsCount;

    /**
     * 批评与自我批评数
     */
	@ExcelProperty(value = "批评与自我批评数")
	@ApiModelProperty("批评与自我批评数")
	private Integer criticismCount;

    /**
     * 整改措施数
     */
	@ExcelProperty(value = "整改措施数")
	@ApiModelProperty("整改措施数")
	private Integer rectificationCount;

    /**
     * 整改完成情况
     */
	@ExcelProperty(value = "整改完成情况")
	@ApiModelProperty("整改完成情况")
	private Integer completionRate;


}
