package com.ruoyi.system.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.ruoyi.common.annotation.ExcelDictFormat;
import com.ruoyi.common.convert.ExcelDictConvert;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 三会一课
 * <p>
 * 视图对象 tb_dzb_meetings_count
 *
 * @author ruoyi
 * @date 2021-10-26
 */
@Data
@ApiModel("三会一课视图对象")
@ExcelIgnoreUnannotated
public class TbDzbMeetingsCountVo {

    private static final long serialVersionUID = 1L;

    /**
     *
     */
    @ApiModelProperty("")
    private Long id;

    /**
     * 组织名称
     */
    @ExcelProperty(value = "组织名称")
    @ApiModelProperty("组织名称")
    private String name;

    /**
     * 类型（frequency:开展频次，activityContent:活动内容，attendanceRate：到会率，leaveRate：请假率）
     */
    @ExcelProperty(value = "类型", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "f=requency:开展频次，activityContent:活动内容，attendanceRate：到会率，leaveRate：请假率")
    @ApiModelProperty("类型（frequency:开展频次，activityContent:活动内容，attendanceRate：到会率，leaveRate：请假率）")
    private String type;

    /**
     * 会议名称/XX名字
     */
    @ExcelProperty(value = "会议名称/XX名字")
    @ApiModelProperty("会议名称/XX名字")
    private String childName;

    /**
     * 对应值
     */
    @ExcelProperty(value = "对应值")
    @ApiModelProperty("对应值")
    private Integer value;

    /**
     * 编号
     */
    @ExcelProperty(value = "编号")
    @ApiModelProperty("编号")
    private String number;

}
