package com.ruoyi.system.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.ruoyi.common.annotation.ExcelDictFormat;
import com.ruoyi.common.convert.ExcelDictConvert;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.util.Date;



/**
 * 民主评议/谈心谈话视图对象 tb_dzb_review_conversation_count
 *
 * @author ruoyi
 * @date 2021-10-26
 */
@Data
@ApiModel("民主评议/谈心谈话视图对象")
@ExcelIgnoreUnannotated
public class TbDzbReviewConversationCountVo {

	private static final long serialVersionUID = 1L;

	/**
     *  
     */
	@ApiModelProperty("")
	private Long id;

    /**
     * 组织名称
     */
	@ExcelProperty(value = "组织名称")
	@ApiModelProperty("组织名称")
	private String name;

    /**
     * 优秀率
     */
	@ExcelProperty(value = "优秀率")
	@ApiModelProperty("优秀率")
	private Integer excellentRate;

    /**
     * 合格率
     */
	@ExcelProperty(value = "合格率")
	@ApiModelProperty("合格率")
	private Integer qualifiedRate;

    /**
     * 基本合格率
     */
	@ExcelProperty(value = "基本合格率")
	@ApiModelProperty("基本合格率")
	private Integer basicQualifiedRate;

    /**
     * 不合格率
     */
	@ExcelProperty(value = "不合格率")
	@ApiModelProperty("不合格率")
	private Integer unqualifiedRate;

    /**
     * 书记与委员谈话数
     */
	@ExcelProperty(value = "书记与委员谈话数")
	@ApiModelProperty("书记与委员谈话数")
	private Integer swCount;

    /**
     * 委员与委员谈话数
     */
	@ExcelProperty(value = "委员与委员谈话数")
	@ApiModelProperty("委员与委员谈话数")
	private Integer wwCount;

    /**
     * 委员与党员谈话数
     */
	@ExcelProperty(value = "委员与党员谈话数")
	@ApiModelProperty("委员与党员谈话数")
	private Integer wdCount;

    /**
     * 党员与党员谈话数
     */
	@ExcelProperty(value = "党员与党员谈话数")
	@ApiModelProperty("党员与党员谈话数")
	private Integer ddCount;


}
