package com.ruoyi.system.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.ruoyi.common.annotation.ExcelDictFormat;
import com.ruoyi.common.convert.ExcelDictConvert;
import com.ruoyi.system.domain.ZkActivityObj;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;


/**
 * 活动详情主体视图对象 zk_activity_info
 *
 * @author ruoyi
 * @date 2021-10-27
 */
@Data
@ApiModel("活动详情主体视图对象For edit")
@ExcelIgnoreUnannotated
public class ZkActivityInfoForEditVo {

	private static final long serialVersionUID = 1L;

	/**
     *
     */
	@ApiModelProperty("")
	private Long id;

    /**
     * zk_activity_type表对应id
     */
	@ExcelProperty(value = "zk_activity_type表对应id")
	@ApiModelProperty("zk_activity_type表对应id")
	private Long titleType;

    /**
     * 参加党支部部门id
     */
	@ExcelProperty(value = "参加党支部部门id")
	@ApiModelProperty("参加党支部部门id")
	private String deptIds;

    /**
     * 活动主题
     */
	@ExcelProperty(value = "活动主题")
	@ApiModelProperty("活动主题")
	private String theme;

    /**
     * 活动类型
     */
	@ExcelProperty(value = "活动类型")
	@ApiModelProperty("活动类型")
	private String type;
    /**
     * 活动类型
     */
	@ExcelProperty(value = "活动类型名")
	@ApiModelProperty("活动类型名")
	private String typeName;

    /**
     * 活动标签（党支部名称+活动时间）
     */
	@ExcelProperty(value = "活动标签", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "党=支部名称+活动时间")
	@ApiModelProperty("活动标签（党支部名称+活动时间）")
	private String activityLabel;

    /**
     * 活动时间
     */
	@ExcelProperty(value = "活动时间")
	@ApiModelProperty("活动时间")
	private Date activityDate;

    /**
     * 活动地址
     */
	@ExcelProperty(value = "活动地址")
	@ApiModelProperty("活动地址")
	private String address;

    /**
     * 主持人
     */
	@ExcelProperty(value = "主持人")
	@ApiModelProperty("主持人")
	private String hostUser;

    /**
     * 记录人
     */
	@ExcelProperty(value = "记录人")
	@ApiModelProperty("记录人")
	private String recorder;

    /**
     * 列席人员
     */
	@ExcelProperty(value = "列席人员")
	@ApiModelProperty("列席人员")
	private String nvPersonnel;

    /**
     * 活动时长
     */
	@ExcelProperty(value = "活动时长")
	@ApiModelProperty("活动时长")
	private Integer duration;

    /**
     * 活动照片
     */
	@ExcelProperty(value = "活动照片")
	@ApiModelProperty("活动照片")
	private String photo;

    /**
     * 创建人
     */
	@ExcelProperty(value = "创建人")
	@ApiModelProperty("创建人")
	private String createUser;

    /**
     *
     */
	@ExcelProperty(value = "")
	@ApiModelProperty("")
	private String lastUpdateUser;

    /**
     * 发布主体
     */
	@ApiModelProperty("发布主体Id")
	private Long pDeptId;

    /**
     * 发布主体
     */
	@ExcelProperty(value = "发布主体")
	@ApiModelProperty("发布主体")
	private String pDeptName;

    /**
     * 发布时间
     */
	@ExcelProperty(value = "发布时间")
	@ApiModelProperty("发布时间")
	private Date releaseTime;

    /**
     * 活动截至时间
     */
	@ExcelProperty(value = "活动截至时间")
	@ApiModelProperty("活动截至时间")
	private Date overTime;

    /**
     * 活动开展时间
     */
	@ExcelProperty(value = "活动开展时间")
	@ApiModelProperty("活动开展时间")
	private Date executionTime;

    /**
     * 活动状态（0：未完成；1：已完成）
     */
	@ExcelProperty(value = "活动状态", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "0=：未完成；1：已完成")
	@ApiModelProperty("活动状态（0：未完成；1：已完成）")
	private Integer status;


    @ApiModelProperty(value = "活动对象列表")
    private List<ZkActivityObjVo> objBos;

    @ApiModelProperty(value = "活动内容列表")
    private List<ZkActivityInfoContentVo> contents;

    @ApiModelProperty(value = "已参加人员")
    private String participatedUser;

    @ApiModelProperty(value = "请假人员")
    private String leaveUser;

    @ApiModelProperty(value = "无故缺席人员")
    private String absentUser;

    @ApiModelProperty(value = "不计入应到会人员")
    private String unUser;

    @ApiModelProperty(value = "流动党员")
    private String ldUser;

    @ApiModelProperty(value = "到会率")
    private String attendanceRate;

    @ApiModelProperty("组织评定列表")
    private List<ZkActivityEvaluateForAddVo> evaluate;

}
