package com.ruoyi.system.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.ruoyi.common.annotation.ExcelDictFormat;
import com.ruoyi.common.convert.ExcelDictConvert;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.util.Date;



/**
 * 活动对象人员信息视图对象 zk_activity_obj_user
 *
 * @author ruoyi
 * @date 2021-11-02
 */
@Data
@ApiModel("活动对象人员信息视图对象")
@ExcelIgnoreUnannotated
public class ZkActivityObjUserVo {

	private static final long serialVersionUID = 1L;

	/**
     *
     */
	@ApiModelProperty("")
	private Long id;

    /**
     * 活动id
     */
	@ExcelProperty(value = "活动id")
	@ApiModelProperty("活动id")
	private Long activityId;

    @ApiModelProperty(value = "活动对象id")
    private Long activityObjId;

    /**
     * 人员类型（0正常，1缺席，2请假）
     */
	@ExcelProperty(value = "人员类型", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "0=正常，1缺席，2请假")
	@ApiModelProperty("人员类型（0正常，1缺席，2请假）")
	private Long type;

    /**
     *
     */
	@ExcelProperty(value = "")
	@ApiModelProperty("")
	private Long userId;

    /**
     * 人员名字
     */
	@ExcelProperty(value = "人员名字")
	@ApiModelProperty("人员名字")
	private String userName;


}
