package com.ruoyi.system.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.ruoyi.system.domain.ZkActivityObjUser;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;


/**
 * 活动主体中的活动对象视图对象 zk_activity_obj
 *
 * @author ruoyi
 * @date 2021-10-27
 */
@Data
@ApiModel("活动主体中的活动对象视图对象")
@ExcelIgnoreUnannotated
public class ZkActivityObjVo {

    private static final long serialVersionUID = 1L;

    /**
     *
     */
    @ApiModelProperty("")
    private Long id;

    /**
     * 对应活动id
     */
    @ExcelProperty(value = "对应活动id")
    @ApiModelProperty("对应活动id")
    private Long activityId;

    /**
     * 活动对象标签名称
     */
    @ExcelProperty(value = "活动对象标签名称")
    @ApiModelProperty("活动对象标签名称")
    private String label;

    /**
     * 活动对象Key
     */
    @ExcelProperty(value = "活动对象Key")
    @ApiModelProperty("活动对象Key")
    private String objKey;

    /**
     * 活动对象value
     */
    @ExcelProperty(value = "活动对象value")
    @ApiModelProperty("活动对象value")
    private String objValue;

    /**
     * 删除状态
     */
    @ExcelProperty(value = "删除状态")
    @ApiModelProperty("删除状态")
    private Integer isDel;


    @ApiModelProperty(value = "活动对象用户列表")
    private List<ZkActivityObjUser> objUsers;

}
