package com.ruoyi.system.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.ruoyi.common.annotation.ExcelDictFormat;
import com.ruoyi.common.convert.ExcelDictConvert;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.util.Date;



/**
 * 活动类型与活动内容关联视图对象 zk_activity_type_content
 *
 * @author ruoyi
 * @date 2021-10-27
 */
@Data
@ApiModel("活动类型与活动内容关联视图对象")
@ExcelIgnoreUnannotated
public class ZkActivityTypeContentVo {

	private static final long serialVersionUID = 1L;

	/**
     *  
     */
	@ApiModelProperty("")
	private Long id;

    /**
     * 活动分类
     */
	@ExcelProperty(value = "活动分类")
	@ApiModelProperty("活动分类")
	private String type;

    /**
     * 活动id（1，2）
     */
	@ExcelProperty(value = "活动id", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "1=，2")
	@ApiModelProperty("活动id（1，2）")
	private String contentIds;

    /**
     * 删除标识
     */
	@ExcelProperty(value = "删除标识")
	@ApiModelProperty("删除标识")
	private Integer isDel;


}
