package com.ruoyi.system.service;

import com.ruoyi.common.core.domain.entity.SysDept;
import com.ruoyi.system.domain.bo.CockpitBo;
import com.ruoyi.system.domain.vo.DeptTreeVo;

import java.util.List;
import java.util.Map;

public interface ICockpitService {


    /**
     * 构建前端所需要树结构
     *
     * @param depts 部门列表
     * @return 树结构列表
     */
    List<DeptTreeVo> buildDeptTree(List<SysDept> depts);

    /**
     * 党支部人员信息统计
     * @param bo
     * @return
     */
    Map<String, Object> getDept(CockpitBo bo);

    /**
     * 三会一课——开展频次
     * @param bo
     * @return
     */
    Map<String, Object> getDevelopmentFrequency(CockpitBo bo);

    /**
     * 三会一课——活动内容统计
     * @param bo
     * @return
     */
    Map<String, Object> getActivityContent(CockpitBo bo);

    /**
     * 三会一课——到会率
     * @param bo
     * @return
     */
    Map<String, Object> getAttendanceRate(CockpitBo bo);
    /**
     * 三会一课——请假率
     * @param bo
     * @return
     */
    Map<String, Object> getLeaveRate(CockpitBo bo);

    /**
     * 主题党日
     * @param bo
     * @return
     */
    Map<String, Object> getThemePartyDay(CockpitBo bo);

    /**
     * 组织生活会
     * @param bo
     * @return
     */
    Map<String, Object> getPartyLife(CockpitBo bo);

    /**
     * 民主评议
     * @param bo
     * @return
     */
    Map<String, Object> getDemocraticAppraisal(CockpitBo bo);

    /**
     * 组织生活规范指数
     * @param bo
     * @return
     */
    Map<String, Object> getIndex(CockpitBo bo);
}
