package com.ruoyi.system.service;

import com.ruoyi.system.domain.TbDzbCount;
import com.ruoyi.system.domain.vo.TbDzbCountVo;
import com.ruoyi.system.domain.bo.TbDzbCountBo;
import com.ruoyi.common.core.mybatisplus.core.IServicePlus;
import com.ruoyi.common.core.page.TableDataInfo;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 *  党支部基层数据大屏统计Service接口
 *
 * @author ruoyi
 * @date 2021-10-26
 */
public interface ITbDzbCountService extends IServicePlus<TbDzbCount, TbDzbCountVo> {
	/**
	 * 查询单个
	 * @return
	 */
	TbDzbCountVo queryById(Long id);

	/**
	 * 查询列表
	 */
    TableDataInfo<TbDzbCountVo> queryPageList(TbDzbCountBo bo);

	/**
	 * 查询列表
	 */
	List<TbDzbCountVo> queryList(TbDzbCountBo bo);

	/**
	 * 根据新增业务对象插入 党支部基层数据大屏统计
	 * @param bo  党支部基层数据大屏统计新增业务对象
	 * @return
	 */
	Boolean insertByBo(TbDzbCountBo bo);

	/**
	 * 根据编辑业务对象修改 党支部基层数据大屏统计
	 * @param bo  党支部基层数据大屏统计编辑业务对象
	 * @return
	 */
	Boolean updateByBo(TbDzbCountBo bo);

	/**
	 * 校验并删除数据
	 * @param ids 主键集合
	 * @param isValid 是否校验,true-删除前校验,false-不校验
	 * @return
	 */
	Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    List<Map<String, Object>> getScreen();
}
