package com.ruoyi.system.service;

import com.ruoyi.system.domain.TbDzbGatheringsCount;
import com.ruoyi.system.domain.vo.TbDzbGatheringsCountVo;
import com.ruoyi.system.domain.bo.TbDzbGatheringsCountBo;
import com.ruoyi.common.core.mybatisplus.core.IServicePlus;
import com.ruoyi.common.core.page.TableDataInfo;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 组织生活会/民主生活会 数据统计Service接口
 *
 * @author ruoyi
 * @date 2021-10-26
 */
public interface ITbDzbGatheringsCountService extends IServicePlus<TbDzbGatheringsCount, TbDzbGatheringsCountVo> {
	/**
	 * 查询单个
	 * @return
	 */
	TbDzbGatheringsCountVo queryById(Long id);

	/**
	 * 查询列表
	 */
    TableDataInfo<TbDzbGatheringsCountVo> queryPageList(TbDzbGatheringsCountBo bo);

	/**
	 * 查询列表
	 */
	List<TbDzbGatheringsCountVo> queryList(TbDzbGatheringsCountBo bo);

	/**
	 * 根据新增业务对象插入组织生活会/民主生活会 数据统计
	 * @param bo 组织生活会/民主生活会 数据统计新增业务对象
	 * @return
	 */
	Boolean insertByBo(TbDzbGatheringsCountBo bo);

	/**
	 * 根据编辑业务对象修改组织生活会/民主生活会 数据统计
	 * @param bo 组织生活会/民主生活会 数据统计编辑业务对象
	 * @return
	 */
	Boolean updateByBo(TbDzbGatheringsCountBo bo);

	/**
	 * 校验并删除数据
	 * @param ids 主键集合
	 * @param isValid 是否校验,true-删除前校验,false-不校验
	 * @return
	 */
	Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    List<Map<String, Object>> getScreen();
}
