package com.ruoyi.system.service;

import com.ruoyi.system.domain.TbDzbMeetingsCount;
import com.ruoyi.system.domain.vo.TbDzbMeetingsCountVo;
import com.ruoyi.system.domain.bo.TbDzbMeetingsCountBo;
import com.ruoyi.common.core.mybatisplus.core.IServicePlus;
import com.ruoyi.common.core.page.TableDataInfo;

import java.util.Collection;
import java.util.List;

/**
 * 三会一课

Service接口
 *
 * @author ruoyi
 * @date 2021-10-26
 */
public interface ITbDzbMeetingsCountService extends IServicePlus<TbDzbMeetingsCount, TbDzbMeetingsCountVo> {
	/**
	 * 查询单个
	 * @return
	 */
	TbDzbMeetingsCountVo queryById(Long id);

	/**
	 * 查询列表
	 */
    TableDataInfo<TbDzbMeetingsCountVo> queryPageList(TbDzbMeetingsCountBo bo);

	/**
	 * 查询列表
	 */
	List<TbDzbMeetingsCountVo> queryList(TbDzbMeetingsCountBo bo);

	/**
	 * 根据新增业务对象插入三会一课


	 * @param bo 三会一课

新增业务对象
	 * @return
	 */
	Boolean insertByBo(TbDzbMeetingsCountBo bo);

	/**
	 * 根据编辑业务对象修改三会一课


	 * @param bo 三会一课

编辑业务对象
	 * @return
	 */
	Boolean updateByBo(TbDzbMeetingsCountBo bo);

	/**
	 * 校验并删除数据
	 * @param ids 主键集合
	 * @param isValid 是否校验,true-删除前校验,false-不校验
	 * @return
	 */
	Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);
}
