package com.ruoyi.system.service;

import com.ruoyi.system.domain.TbDzbReviewConversationCount;
import com.ruoyi.system.domain.vo.TbDzbReviewConversationCountVo;
import com.ruoyi.system.domain.bo.TbDzbReviewConversationCountBo;
import com.ruoyi.common.core.mybatisplus.core.IServicePlus;
import com.ruoyi.common.core.page.TableDataInfo;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 民主评议/谈心谈话Service接口
 *
 * @author ruoyi
 * @date 2021-10-26
 */
public interface ITbDzbReviewConversationCountService extends IServicePlus<TbDzbReviewConversationCount, TbDzbReviewConversationCountVo> {
	/**
	 * 查询单个
	 * @return
	 */
	TbDzbReviewConversationCountVo queryById(Long id);

	/**
	 * 查询列表
	 */
    TableDataInfo<TbDzbReviewConversationCountVo> queryPageList(TbDzbReviewConversationCountBo bo);

	/**
	 * 查询列表
	 */
	List<TbDzbReviewConversationCountVo> queryList(TbDzbReviewConversationCountBo bo);

	/**
	 * 根据新增业务对象插入民主评议/谈心谈话
	 * @param bo 民主评议/谈心谈话新增业务对象
	 * @return
	 */
	Boolean insertByBo(TbDzbReviewConversationCountBo bo);

	/**
	 * 根据编辑业务对象修改民主评议/谈心谈话
	 * @param bo 民主评议/谈心谈话编辑业务对象
	 * @return
	 */
	Boolean updateByBo(TbDzbReviewConversationCountBo bo);

	/**
	 * 校验并删除数据
	 * @param ids 主键集合
	 * @param isValid 是否校验,true-删除前校验,false-不校验
	 * @return
	 */
	Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    List<Map<String, Object>> getScreen();
}
