package com.ruoyi.system.service;

import com.ruoyi.system.domain.TbDzbThemeCount;
import com.ruoyi.system.domain.vo.TbDzbThemeCountVo;
import com.ruoyi.system.domain.bo.TbDzbThemeCountBo;
import com.ruoyi.common.core.mybatisplus.core.IServicePlus;
import com.ruoyi.common.core.page.TableDataInfo;

import java.util.Collection;
import java.util.List;

/**
 * 主题党日 数据统计Service接口
 *
 * @author ruoyi
 * @date 2021-10-26
 */
public interface ITbDzbThemeCountService extends IServicePlus<TbDzbThemeCount, TbDzbThemeCountVo> {
	/**
	 * 查询单个
	 * @return
	 */
	TbDzbThemeCountVo queryById(Long id);

	/**
	 * 查询列表
	 */
    TableDataInfo<TbDzbThemeCountVo> queryPageList(TbDzbThemeCountBo bo);

	/**
	 * 查询列表
	 */
	List<TbDzbThemeCountVo> queryList(TbDzbThemeCountBo bo);

	/**
	 * 根据新增业务对象插入主题党日 数据统计
	 * @param bo 主题党日 数据统计新增业务对象
	 * @return
	 */
	Boolean insertByBo(TbDzbThemeCountBo bo);

	/**
	 * 根据编辑业务对象修改主题党日 数据统计
	 * @param bo 主题党日 数据统计编辑业务对象
	 * @return
	 */
	Boolean updateByBo(TbDzbThemeCountBo bo);

	/**
	 * 校验并删除数据
	 * @param ids 主键集合
	 * @param isValid 是否校验,true-删除前校验,false-不校验
	 * @return
	 */
	Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);
}
